/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionExecutor
implements TransactionExecutor,
TransactionHandler {
    private static final Log _log = LogFactoryUtil.getLog(DefaultTransactionExecutor.class);

    @Override
    public void commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        Throwable throwable = null;
        try {
            platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (RuntimeException re) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
            throwable = re;
            throw re;
        }
        catch (Error e) {
            _log.error((Object)"Application exception overridden by commit error", (Throwable)e);
            throwable = e;
            throw e;
        }
        finally {
            if (throwable != null) {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)throwable);
            } else {
                TransactionLifecycleManager.fireTransactionCommittedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
            }
        }
    }

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this.start(platformTransactionManager, transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.rollback(platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        return returnValue;
    }

    @Override
    public void rollback(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        if (transactionAttributeAdapter.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (RuntimeException re) {
                re.addSuppressed(throwable);
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                throw re;
            }
            catch (Error e) {
                e.addSuppressed(throwable);
                _log.error((Object)"Application exception overridden by rollback error", (Throwable)e);
                throw e;
            }
            finally {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)throwable);
            }
        } else {
            this.commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter);
        }
        throw throwable;
    }

    @Override
    public TransactionStatusAdapter start(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter) {
        TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
        TransactionLifecycleManager.fireTransactionCreatedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
        return transactionStatusAdapter;
    }
}

