/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

public class SetupWizardUtil {
    public static final String PROPERTIES_FILE_NAME = "portal-setup-wizard.properties";
    private static final String _PROPERTIES_PREFIX = "properties--";
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardUtil.class);

    public static String getDefaultLanguageId() {
        Locale defaultLocale = LocaleUtil.getDefault();
        return LocaleUtil.toLanguageId((Locale)defaultLocale);
    }

    public static boolean isDefaultDatabase(HttpServletRequest request) {
        boolean hsqldb = ParamUtil.getBoolean((HttpServletRequest)request, (String)"defaultDatabase", (boolean)PropsValues.JDBC_DEFAULT_URL.contains("hsqldb"));
        boolean jndi = Validator.isNotNull((String)PropsValues.JDBC_DEFAULT_JNDI_NAME);
        return hsqldb && !jndi;
    }

    public static void testDatabase(HttpServletRequest request) throws Exception {
        String driverClassName = SetupWizardUtil._getParameter(request, "jdbc.default.driverClassName", PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME);
        String url = SetupWizardUtil._getParameter(request, "jdbc.default.url", null);
        String userName = SetupWizardUtil._getParameter(request, "jdbc.default.username", null);
        String password = SetupWizardUtil._getParameter(request, "jdbc.default.password", null);
        String jndiName = "";
        if (Validator.isNotNull((String)PropsValues.JDBC_DEFAULT_JNDI_NAME)) {
            jndiName = PropsValues.JDBC_DEFAULT_JNDI_NAME;
        }
        SetupWizardUtil._testConnection(driverClassName, url, userName, password, jndiName);
    }

    public static void updateLanguage(HttpServletRequest request, HttpServletResponse response) {
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"companyLocale", (String)SetupWizardUtil.getDefaultLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
            return;
        }
        HttpSession session = request.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        session.setAttribute("SETUP_WIZARD_DEFAULT_LOCALE", (Object)languageId);
        LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLanguageId(languageId);
        themeDisplay.setLocale(locale);
    }

    public static void updateSetup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties((HttpServletRequest)request, (String)_PROPERTIES_PREFIX);
        unicodeProperties.setProperty("liferay.home", SystemProperties.get((String)"liferay.home"));
        boolean databaseConfigured = SetupWizardUtil._isDatabaseConfigured(unicodeProperties);
        SetupWizardUtil._processDatabaseProperties(request, unicodeProperties, databaseConfigured);
        SetupWizardUtil._processOtherProperties(request, unicodeProperties);
        SetupWizardUtil.updateLanguage(request, response);
        unicodeProperties.put("setup.wizard.enabled", String.valueOf(false));
        SetupWizardUtil._updateCompany(request);
        SetupWizardUtil._updateAdminUser(request, response, unicodeProperties);
        HttpSession session = request.getSession();
        session.setAttribute("SETUP_WIZARD_PROPERTIES", (Object)unicodeProperties);
        session.setAttribute("SETUP_WIZARD_PROPERTIES_FILE_CREATED", (Object)SetupWizardUtil._writePropertiesFile(unicodeProperties));
    }

    private static String _getParameter(HttpServletRequest request, String name, String defaultValue) {
        name = _PROPERTIES_PREFIX.concat(name).concat("--");
        return ParamUtil.getString((HttpServletRequest)request, (String)name, (String)defaultValue);
    }

    private static boolean _isDatabaseConfigured(UnicodeProperties unicodeProperties) {
        String defaultDriverClassName = (String)unicodeProperties.get((Object)"jdbc.default.driverClassName");
        String defaultPassword = (String)unicodeProperties.get((Object)"jdbc.default.password");
        String defaultURL = (String)unicodeProperties.get((Object)"jdbc.default.url");
        String defaultUsername = (String)unicodeProperties.get((Object)"jdbc.default.username");
        return PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME.equals(defaultDriverClassName) && PropsValues.JDBC_DEFAULT_PASSWORD.equals(defaultPassword) && PropsValues.JDBC_DEFAULT_URL.equals(defaultURL) && PropsValues.JDBC_DEFAULT_USERNAME.equals(defaultUsername);
    }

    private static void _processDatabaseProperties(HttpServletRequest request, UnicodeProperties unicodeProperties, boolean databaseConfigured) throws Exception {
        boolean defaultDatabase = ParamUtil.getBoolean((HttpServletRequest)request, (String)"defaultDatabase", (boolean)true);
        if (defaultDatabase || databaseConfigured) {
            unicodeProperties.remove((Object)"jdbc.default.url");
            unicodeProperties.remove((Object)"jdbc.default.driverClassName");
            unicodeProperties.remove((Object)"jdbc.default.username");
            unicodeProperties.remove((Object)"jdbc.default.password");
        }
    }

    private static void _processOtherProperties(HttpServletRequest request, UnicodeProperties unicodeProperties) throws Exception {
        SetupWizardUtil._processProperty(request, unicodeProperties, "adminFirstName", "default.admin.first.name", PropsValues.DEFAULT_ADMIN_FIRST_NAME);
        SetupWizardUtil._processProperty(request, unicodeProperties, "adminLastName", "default.admin.last.name", PropsValues.DEFAULT_ADMIN_LAST_NAME);
        SetupWizardUtil._processProperty(request, unicodeProperties, "companyName", "company.default.name", PropsValues.COMPANY_DEFAULT_NAME);
    }

    private static void _processProperty(HttpServletRequest request, UnicodeProperties unicodeProperties, String parameterName, String propertyKey, String defaultValue) throws Exception {
        String value = ParamUtil.getString((HttpServletRequest)request, (String)parameterName, (String)defaultValue);
        if (!value.equals(defaultValue)) {
            unicodeProperties.put(propertyKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _testConnection(String driverClassName, String url, String userName, String password, String jndiName) throws Exception {
        if (Validator.isNull((String)jndiName)) {
            Class.forName(driverClassName);
        }
        DataSource dataSource = null;
        Connection connection = null;
        try {
            dataSource = DataSourceFactoryUtil.initDataSource((String)driverClassName, (String)url, (String)userName, (String)password, (String)jndiName);
            connection = dataSource.getConnection();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(connection);
            DataSourceFactoryUtil.destroyDataSource(dataSource);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection);
        DataSourceFactoryUtil.destroyDataSource((DataSource)dataSource);
    }

    private static void _updateAdminUser(HttpServletRequest request, HttpServletResponse response, UnicodeProperties unicodeProperties) throws Exception {
        String fullName;
        String emailAddress;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = CompanyLocalServiceUtil.getCompanyById((long)themeDisplay.getCompanyId());
        PropsValues.ADMIN_EMAIL_FROM_ADDRESS = emailAddress = ParamUtil.getString((HttpServletRequest)request, (String)"adminEmailAddress", (String)(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + company.getMx()));
        unicodeProperties.put("admin.email.from.address", emailAddress);
        ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
        String screenName = GetterUtil.getString((String)PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX, (String)"test");
        try {
            screenName = screenNameGenerator.generate(0L, 0L, emailAddress);
        }
        catch (Exception e) {
            // empty catch block
        }
        String firstName = ParamUtil.getString((HttpServletRequest)request, (String)"adminFirstName", (String)PropsValues.DEFAULT_ADMIN_FIRST_NAME);
        String lastName = ParamUtil.getString((HttpServletRequest)request, (String)"adminLastName", (String)PropsValues.DEFAULT_ADMIN_LAST_NAME);
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        PropsValues.ADMIN_EMAIL_FROM_NAME = fullName = fullNameGenerator.getFullName(firstName, null, lastName);
        unicodeProperties.put("admin.email.from.name", fullName);
        User user = UserLocalServiceUtil.fetchUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
        if (user != null) {
            String greeting = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"welcome-x", (Object)fullName, (boolean)false);
            Contact contact = user.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(contact.getBirthday());
            int birthdayMonth = birthdayCal.get(2);
            int birthdayDay = birthdayCal.get(5);
            int birthdayYear = birthdayCal.get(1);
            user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)user.getReminderQueryQuestion(), (String)user.getReminderQueryAnswer(), (String)screenName, (String)emailAddress, (long)user.getFacebookId(), (String)user.getOpenId(), (boolean)false, null, (String)themeDisplay.getLanguageId(), (String)user.getTimeZoneId(), (String)greeting, (String)user.getComments(), (String)firstName, (String)user.getMiddleName(), (String)lastName, (long)contact.getPrefixId(), (long)contact.getSuffixId(), (boolean)contact.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getFacebookSn(), (String)contact.getJabberSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getJobTitle(), null, null, null, null, null, (ServiceContext)new ServiceContext());
        } else {
            User testUser;
            UserLocalServiceUtil.addDefaultAdminUser((long)themeDisplay.getCompanyId(), (String)screenName, (String)emailAddress, (Locale)themeDisplay.getLocale(), (String)firstName, (String)"", (String)lastName);
            user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
            String defaultAdminEmailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + PropsValues.COMPANY_DEFAULT_WEB_ID;
            if (!emailAddress.equals(defaultAdminEmailAddress) && (testUser = UserLocalServiceUtil.fetchUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)defaultAdminEmailAddress)) != null) {
                UserLocalServiceUtil.updateStatus((long)testUser.getUserId(), (int)5, (ServiceContext)new ServiceContext());
            }
        }
        user = UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
        HttpSession session = request.getSession();
        session.setAttribute("EMAIL_ADDRESS", (Object)emailAddress);
        session.setAttribute("SETUP_WIZARD_PASSWORD_UPDATED", (Object)true);
        session.setAttribute("USER", (Object)user);
        session.setAttribute("USER_ID", (Object)user.getUserId());
        EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, request, response);
    }

    private static void _updateCompany(HttpServletRequest request) throws Exception {
        String newName;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
        Account account = company.getAccount();
        String currentName = account.getName();
        if (!currentName.equals(newName = ParamUtil.getString((HttpServletRequest)request, (String)"companyName", (String)PropsValues.COMPANY_DEFAULT_NAME))) {
            account.setName(newName);
            AccountLocalServiceUtil.updateAccount((Account)account);
        }
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"companyLocale", (String)SetupWizardUtil.getDefaultLanguageId());
        User defaultUser = company.getDefaultUser();
        defaultUser.setLanguageId(languageId);
        UserLocalServiceUtil.updateUser((User)defaultUser);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setCompany(company);
    }

    private static boolean _writePropertiesFile(UnicodeProperties unicodeProperties) {
        try {
            FileUtil.write((String)PropsValues.LIFERAY_HOME, (String)PROPERTIES_FILE_NAME, (String)unicodeProperties.toString());
            if (FileUtil.exists((String)(PropsValues.LIFERAY_HOME + "/" + PROPERTIES_FILE_NAME))) {
                return true;
            }
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        return false;
    }
}

