/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.RSSThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipResponse
extends MetaInfoCacheServletResponse {
    private static final String _GZIP = "gzip";
    private static final Log _log = LogFactoryUtil.getLog(GZipResponse.class);
    private final boolean _firefox;
    private PrintWriter _printWriter;
    private final HttpServletResponse _response;
    private ServletOutputStream _servletOutputStream;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public GZipResponse(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this._response = response;
        this._response.setContentLength(-1);
        this._response.addHeader("Content-Encoding", _GZIP);
        this._firefox = BrowserSnifferUtil.isFirefox((HttpServletRequest)request);
    }

    public void finishResponse(boolean reapplyMetaData) throws IOException {
        if (!this.isCommitted() && (this._servletOutputStream == null || this._servletOutputStream != null && this._unsyncByteArrayOutputStream != null && this._unsyncByteArrayOutputStream.size() == 0)) {
            this._response.reset();
            super.finishResponse(reapplyMetaData);
        }
        try {
            if (this._printWriter != null) {
                this._printWriter.close();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._unsyncByteArrayOutputStream != null) {
            this._response.setContentLength(this._unsyncByteArrayOutputStream.size());
            this._unsyncByteArrayOutputStream.writeTo((OutputStream)this._response.getOutputStream());
        }
    }

    public void flushBuffer() throws IOException {
        if (this._servletOutputStream != null) {
            this._servletOutputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._printWriter != null) {
            throw new IllegalStateException();
        }
        if (this._servletOutputStream == null) {
            if (this._isGZipContentType()) {
                this._servletOutputStream = this._response.getOutputStream();
            } else if (this._firefox && RSSThreadLocal.isExportRSS()) {
                this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                this._servletOutputStream = this._createGZipServletOutputStream((OutputStream)this._unsyncByteArrayOutputStream);
            } else {
                this._servletOutputStream = this._createGZipServletOutputStream((OutputStream)this._response.getOutputStream());
            }
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._printWriter != null) {
            return this._printWriter;
        }
        if (this._servletOutputStream != null) {
            throw new IllegalStateException();
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Use getOutputStream for optimum performance");
        }
        this._servletOutputStream = this.getOutputStream();
        this._printWriter = UnsyncPrintWriterPool.borrow((OutputStream)this._servletOutputStream, (String)this.getCharacterEncoding());
        return this._printWriter;
    }

    public void setContentLength(int contentLength) {
    }

    public void setHeader(String name, String value) {
        if ("Content-Length".equals(name)) {
            return;
        }
        super.setHeader(name, value);
    }

    private ServletOutputStream _createGZipServletOutputStream(OutputStream outputStream) throws IOException {
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream){
            {
                this.def.setLevel(PropsValues.GZIP_COMPRESSION_LEVEL);
            }
        };
        return new ServletOutputStreamAdapter((OutputStream)gzipOutputStream);
    }

    private boolean _isGZipContentType() {
        String contentType = this.getContentType();
        return contentType != null && (contentType.equals("application/gzip") || contentType.equals("application/x-gzip"));
    }
}

