/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.external;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;

public class LegacyExternalRepositoryFactory
implements RepositoryFactory {
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=DLAppHelperLocalService.class)
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;
    @BeanReference(type=RepositoryEntryLocalService.class)
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        BaseRepository baseRepository = this.createBaseRepository(repositoryId);
        return baseRepository.getLocalRepository();
    }

    public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
        return this.createBaseRepository(repositoryId);
    }

    protected BaseRepository createBaseRepository(long repositoryId) throws PortalException {
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        return this.createExternalRepositoryImpl(repositoryId, classNameId);
    }

    protected BaseRepository createExternalRepositoryImpl(long repositoryId, long classNameId) throws PortalException {
        BaseRepository baseRepository = null;
        Repository repository = null;
        try {
            repository = this._repositoryLocalService.getRepository(repositoryId);
            ClassName className = this._classNameLocalService.getClassName(classNameId);
            String repositoryImplClassName = className.getValue();
            baseRepository = ExternalRepositoryFactoryUtil.getInstance(repositoryImplClassName);
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to find a valid repository for class name ID " + classNameId, (Throwable)e);
        }
        this.setupRepository(repositoryId, repository, baseRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            baseRepository.initRepository();
        }
        return baseRepository;
    }

    protected long getRepositoryClassNameId(long repositoryId) {
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            return repository.getClassNameId();
        }
        return this._classNameLocalService.getClassNameId(LiferayRepository.class.getName());
    }

    protected void setupRepository(long repositoryId, Repository repository, BaseRepository baseRepository) {
        baseRepository.setAssetEntryLocalService(this._assetEntryLocalService);
        baseRepository.setCompanyId(repository.getCompanyId());
        baseRepository.setCompanyLocalService(this._companyLocalService);
        baseRepository.setDLAppHelperLocalService(this._dlAppHelperLocalService);
        baseRepository.setDLFolderLocalService(this._dlFolderLocalService);
        baseRepository.setGroupId(repository.getGroupId());
        baseRepository.setRepositoryEntryLocalService(this._repositoryEntryLocalService);
        baseRepository.setRepositoryId(repositoryId);
        baseRepository.setTypeSettingsProperties(repository.getTypeSettingsProperties());
        baseRepository.setUserLocalService(this._userLocalService);
    }
}

