/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanUtil;
import jodd.json.BeanSerializer;
import jodd.json.JsonContext;
import jodd.json.JsonSerializer;
import jodd.servlet.ServletUtil;
import jodd.util.NameValue;

public class JSONWebServiceInvokerAction
implements JSONWebServiceAction {
    private static final JsonSerializer _jsonSerializer = new JsonSerializer();
    private final String _command;
    private List<String> _includes;
    private final HttpServletRequest _request;
    private final List<Statement> _statements = new ArrayList<Statement>();

    public JSONWebServiceInvokerAction(HttpServletRequest request) {
        this._request = request;
        String command = request.getParameter("cmd");
        if (command == null) {
            try {
                command = ServletUtil.readRequestBody((HttpServletRequest)request);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        this._command = command;
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        Object command = JSONFactoryUtil.looseDeserialize((String)this._command);
        ArrayList<Object> list = null;
        boolean batchMode = false;
        if (command instanceof List) {
            list = (ArrayList<Object>)command;
            batchMode = true;
        } else if (command instanceof Map) {
            list = new ArrayList<Object>(1);
            list.add(command);
            batchMode = false;
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            if (map.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Set entrySet = map.entrySet();
            Iterator iterator = entrySet.iterator();
            Map.Entry entry = iterator.next();
            Statement statement = this._parseStatement(null, (String)entry.getKey(), (Map)entry.getValue());
            Object result = this._executeStatement(statement);
            list.set(i, result);
        }
        ArrayList<Object> result = null;
        result = !batchMode ? list.get(0) : list;
        return new InvokerResult(result);
    }

    private void _addInclude(Statement statement, String name) {
        if (this._includes == null) {
            this._includes = new ArrayList<String>();
        }
        StringBuilder sb = new StringBuilder();
        while (statement._parentStatement != null) {
            String statementName = statement.getName().substring(1);
            sb.insert(0, statementName + ".");
            statement = statement._parentStatement;
        }
        sb.append(name);
        String includeName = sb.toString();
        if (!this._includes.contains(includeName)) {
            this._includes.add(includeName);
        }
    }

    private Object _addVariableStatement(Statement variableStatement, Object result) throws Exception {
        Statement statement = variableStatement.getParentStatement();
        result = this._populateFlags(statement, result);
        String name = variableStatement.getName();
        Object variableResult = this._executeStatement(variableStatement);
        Map<String, Object> map = this._convertObjectToMap(statement, result, null);
        if (!variableStatement.isInner()) {
            map.put(name.substring(1), variableResult);
            return map;
        }
        int index = name.indexOf(".$");
        String innerObjectName = name.substring(0, index);
        if (innerObjectName.contains(".")) {
            throw new IllegalArgumentException("Inner properties with more than 1 level are not supported");
        }
        Object innerObject = map.get(innerObjectName);
        String innerPropertyName = name.substring(index + 2);
        if (innerObject instanceof List) {
            List innerList = (List)innerObject;
            ArrayList<Map<String, Object>> newInnerList = new ArrayList<Map<String, Object>>(innerList.size());
            for (Object innerListElement : innerList) {
                Map<String, Object> newInnerListElement = this._convertObjectToMap(statement, innerListElement, innerObjectName);
                newInnerListElement.put(innerPropertyName, variableResult);
                newInnerList.add(newInnerListElement);
            }
            map.put(innerObjectName, newInnerList);
        } else {
            Map<String, Object> innerMap = this._convertObjectToMap(statement, innerObject, innerObjectName);
            innerMap.put(innerPropertyName, variableResult);
            map.put(innerObjectName, innerMap);
        }
        return map;
    }

    private Object _addVariableStatementList(Statement variableStatement, List<Object> resultList, List<Object> results) throws Exception {
        for (Object object : resultList) {
            Object value;
            List<Object> listObject = this._convertObjectToList(object);
            if (listObject != null) {
                value = this._addVariableStatementList(variableStatement, listObject, results);
                results.add(value);
                continue;
            }
            value = this._addVariableStatement(variableStatement, object);
            results.add(value);
        }
        return results;
    }

    private List<Object> _convertObjectToList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Iterable) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterable iterable = (Iterable)object;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        Class<?> componentType = clazz.getComponentType();
        if (!componentType.isPrimitive()) {
            return ListUtil.toList((Object[])((Object[])object));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(object); ++i) {
            list.add(Array.get(object, i));
        }
        return list;
    }

    private Map<String, Object> _convertObjectToMap(final Statement statement, Object object, final String prefix) {
        if (object instanceof Map) {
            return (Map)object;
        }
        JsonContext jsonContext = _jsonSerializer.createJsonContext(null);
        final LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        BeanSerializer beanSerializer = new BeanSerializer(jsonContext, object){

            protected void onSerializableProperty(String propertyName, Class propertyClass, Object value) {
                map.put(propertyName, value);
                String include = propertyName;
                if (prefix != null) {
                    include = prefix + "." + include;
                }
                JSONWebServiceInvokerAction.this._addInclude(statement, include);
            }
        };
        beanSerializer.serialize();
        return map;
    }

    private Object _executeStatement(Statement statement) throws Exception {
        JSONWebServiceAction jsonWebServiceAction = JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)this._request, (String)statement.getMethod(), null, statement.getParameterMap());
        Object result = jsonWebServiceAction.invoke();
        result = this._filterResult(statement, result);
        List<Statement> variableStatements = statement.getVariableStatements();
        if (variableStatements == null) {
            return result;
        }
        for (Statement variableStatement : variableStatements) {
            List<Object> resultList;
            boolean innerStatement = variableStatement.isInner();
            if (innerStatement) {
                result = variableStatement.push(result);
            }
            if ((resultList = this._convertObjectToList(result)) != null) {
                result = this._addVariableStatementList(variableStatement, resultList, new ArrayList<Object>());
                variableStatement.setExecuted(true);
                if (!innerStatement) continue;
                result = variableStatement.pop(result);
                continue;
            }
            if (innerStatement) {
                result = variableStatement.pop(result);
            }
            result = this._addVariableStatement(variableStatement, result);
            variableStatement.setExecuted(true);
        }
        return result;
    }

    private Object _filterResult(Statement statement, Object result) {
        List<Object> resultList = this._convertObjectToList(result);
        result = resultList != null ? this._filterResultList(statement, resultList, new ArrayList<Object>()) : this._filterResultObject(statement, result);
        return result;
    }

    private Object _filterResultList(Statement statement, List<Object> resultList, List<Object> results) {
        for (Object object : resultList) {
            Object value = this._filterResultObject(statement, object);
            results.add(value);
        }
        return results;
    }

    private Object _filterResultObject(Statement statement, Object result) {
        if (result == null) {
            return result;
        }
        String[] whitelist = statement.getWhitelist();
        if (whitelist == null) {
            return result;
        }
        Map<String, Object> map = this._convertObjectToMap(statement, result, null);
        HashMap<String, Object> whitelistMap = new HashMap<String, Object>(whitelist.length);
        for (String key : whitelist) {
            Object value = map.get(key);
            whitelistMap.put(key, value);
        }
        return whitelistMap;
    }

    private Statement _parseStatement(Statement parentStatement, String assignment, Map<String, Object> statementBody) {
        Statement statement = new Statement(parentStatement);
        this._statements.add(statement);
        int x = assignment.indexOf("=");
        if (x == -1) {
            statement.setMethod(assignment.trim());
        } else {
            String name = assignment.substring(0, x).trim();
            int y = name.indexOf("[");
            if (y != -1) {
                String whitelistString = name.substring(y + 1, name.length() - 1);
                String[] whiteList = StringUtil.split((String)whitelistString);
                for (int i = 0; i < whiteList.length; ++i) {
                    whiteList[i] = whiteList[i].trim();
                }
                statement.setWhitelist(whiteList);
                name = name.substring(0, y);
            }
            statement.setName(name);
            statement.setMethod(assignment.substring(x + 1).trim());
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(statementBody.size());
        statement.setParameterMap(parameterMap);
        for (String key : statementBody.keySet()) {
            Object value;
            if (key.startsWith("@")) {
                value = (String)statementBody.get(key);
                List<Flag> flags = statement.getFlags();
                if (flags == null) {
                    flags = new ArrayList<Flag>();
                    statement.setFlags(flags);
                }
                Flag flag = new Flag();
                flag.setName(key.substring(1));
                flag.setValue(value);
                flags.add(flag);
                continue;
            }
            if (key.startsWith("$") || key.contains(".$")) {
                Map map = (Map)statementBody.get(key);
                List<Statement> variableStatements = statement.getVariableStatements();
                if (variableStatements == null) {
                    variableStatements = new ArrayList<Statement>();
                    statement.setVariableStatements(variableStatements);
                }
                Statement variableStatement = this._parseStatement(statement, key, map);
                variableStatements.add(variableStatement);
                continue;
            }
            value = statementBody.get(key);
            parameterMap.put(CamelCaseUtil.normalizeCamelCase((String)key), value);
        }
        return statement;
    }

    private Object _populateFlags(Statement statement, Object result) {
        List<Object> listResult = this._convertObjectToList(result);
        if (listResult != null) {
            result = this._populateFlagsList(statement.getName(), listResult, new ArrayList<Object>());
        } else {
            this._populateFlagsObject(statement.getName(), result);
        }
        return result;
    }

    private List<Object> _populateFlagsList(String name, List<Object> list, List<Object> results) {
        for (Object object : list) {
            List<Object> listObject = this._convertObjectToList(object);
            if (listObject != null) {
                List<Object> value = this._populateFlagsList(name, listObject, results);
                results.add(value);
                continue;
            }
            this._populateFlagsObject(name, object);
            results.add(object);
        }
        return results;
    }

    private void _populateFlagsObject(String name, Object object) {
        if (name == null) {
            return;
        }
        String pushedName = null;
        int index = name.indexOf(46);
        if (index != -1) {
            pushedName = name.substring(0, index + 1);
        }
        name = name.concat(".");
        for (Statement statement : this._statements) {
            List<Flag> flags;
            if (statement.isExecuted() || (flags = statement.getFlags()) == null) continue;
            for (Flag flag : flags) {
                Object propertyValue;
                Map<String, Object> parameterMap;
                String value = (String)flag.getValue();
                if (value == null) continue;
                if (value.startsWith(name)) {
                    parameterMap = statement.getParameterMap();
                    propertyValue = BeanUtil.getDeclaredProperty((Object)object, (String)value.substring(name.length()));
                    parameterMap.put((String)flag.getName(), propertyValue);
                    continue;
                }
                if (!statement.isPushed() || !value.startsWith(pushedName)) continue;
                parameterMap = statement.getParameterMap();
                propertyValue = BeanUtil.getDeclaredProperty((Object)statement._pushTarget, (String)value.substring(pushedName.length()));
                parameterMap.put((String)flag.getName(), propertyValue);
            }
        }
    }

    private static class Statement {
        private boolean _executed;
        private List<Flag> _flags;
        private boolean _inner;
        private String _method;
        private String _name;
        private Map<String, Object> _parameterMap;
        private Statement _parentStatement;
        private Object _pushTarget;
        private List<Statement> _variableStatements;
        private String[] _whitelist;

        public List<Flag> getFlags() {
            return this._flags;
        }

        public String getMethod() {
            return this._method;
        }

        public String getName() {
            return this._name;
        }

        public Map<String, Object> getParameterMap() {
            return this._parameterMap;
        }

        public Statement getParentStatement() {
            return this._parentStatement;
        }

        public List<Statement> getVariableStatements() {
            return this._variableStatements;
        }

        public String[] getWhitelist() {
            return this._whitelist;
        }

        public boolean isExecuted() {
            return this._executed;
        }

        public boolean isInner() {
            return this._inner;
        }

        public boolean isPushed() {
            return this._pushTarget != null;
        }

        public Object pop(Object result) {
            if (this._pushTarget == null) {
                return null;
            }
            Statement statement = this.getParentStatement();
            String statementName = statement.getName();
            int index = statementName.lastIndexOf(46);
            String beanName = statementName.substring(index + 1);
            statementName = statementName.substring(0, index);
            statement.setName(statementName);
            this.setName(beanName + "." + this.getName());
            BeanUtil.setDeclaredProperty((Object)this._pushTarget, (String)beanName, (Object)result);
            result = this._pushTarget;
            this._pushTarget = null;
            return result;
        }

        public Object push(Object result) {
            if (this._parentStatement == null) {
                return null;
            }
            this._pushTarget = result;
            Statement statement = this.getParentStatement();
            String variableName = this.getName();
            int index = variableName.indexOf(".$");
            String beanName = variableName.substring(0, index);
            result = BeanUtil.getDeclaredProperty((Object)result, (String)beanName);
            statement.setName(statement.getName() + "." + beanName);
            variableName = variableName.substring(index + 1);
            this.setName(variableName);
            return result;
        }

        public void setExecuted(boolean executed) {
            this._executed = executed;
        }

        public void setFlags(List<Flag> flags) {
            this._flags = flags;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setName(String name) {
            this._inner = name.contains(".$");
            this._name = name;
        }

        public void setParameterMap(Map<String, Object> parameterMap) {
            this._parameterMap = parameterMap;
        }

        public void setVariableStatements(List<Statement> variableStatements) {
            this._variableStatements = variableStatements;
        }

        public void setWhitelist(String[] whitelist) {
            this._whitelist = whitelist;
        }

        private Statement(Statement parentStatement) {
            this._parentStatement = parentStatement;
        }
    }

    private static class Flag
    extends NameValue<String, String> {
        private Flag() {
        }
    }

    public class InvokerResult
    implements JSONSerializable {
        private Object _result;

        public InvokerResult(Object result) {
            this._result = result;
        }

        public JSONWebServiceInvokerAction getJSONWebServiceInvokerAction() {
            return JSONWebServiceInvokerAction.this;
        }

        public Object getResult() {
            return this._result;
        }

        public String toJSONString() {
            if (this._result == null) {
                return JSONFactoryUtil.getNullJSON();
            }
            JSONSerializer jsonSerializer = this.createJSONSerializer();
            if (JSONWebServiceInvokerAction.this._includes != null) {
                for (String include : JSONWebServiceInvokerAction.this._includes) {
                    jsonSerializer.include(new String[]{include});
                }
            }
            return jsonSerializer.serialize(this._result);
        }

        protected JSONSerializer createJSONSerializer() {
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            return jsonSerializer;
        }
    }
}

