/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class PluginContextListener
extends BasePortalLifecycle
implements ServletContextListener {
    protected ClassLoader pluginClassLoader;
    protected ServletContext servletContext;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ClassLoaderPool.unregister(servletContext.getServletContextName());
        this.portalDestroy();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        this.pluginClassLoader = this.servletContext.getClassLoader();
        ClassLoaderPool.register(this.servletContext.getServletContextName(), this.pluginClassLoader);
        ServletContextPool.put(this.servletContext.getServletContextName(), this.servletContext);
        this.registerPortalLifecycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPortalDestroy() throws Exception {
        PluginContextLifecycleThreadLocal.setDestroying(true);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader != this.pluginClassLoader) {
            currentThread.setContextClassLoader(this.pluginClassLoader);
        }
        try {
            this.fireUndeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setDestroying(false);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPortalInit() throws Exception {
        PluginContextLifecycleThreadLocal.setInitializing(true);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader != this.pluginClassLoader) {
            currentThread.setContextClassLoader(this.pluginClassLoader);
        }
        try {
            this.fireDeployEvent();
        }
        finally {
            PluginContextLifecycleThreadLocal.setInitializing(false);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void fireDeployEvent() {
        HotDeployUtil.fireDeployEvent(new HotDeployEvent(this.servletContext));
    }

    protected void fireUndeployEvent() {
        HotDeployUtil.fireUndeployEvent(new HotDeployEvent(this.servletContext));
    }
}

