/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ProviderType
public class UpgradeProcessUtil {
    private static final boolean _INDEX_ON_UPGRADE = GetterUtil.getBoolean(PropsUtil.get("index.on.upgrade"));
    private static final Log _log = LogFactoryUtil.getLog(UpgradeProcessUtil.class);
    private static boolean _createIGImageDocumentType = false;
    private static final Map<Long, String> _languageIds = new HashMap<Long, String>();

    /*
     * Exception decompiling
     */
    public static String getDefaultLanguageId(long companyId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<UpgradeProcess> initUpgradeProcesses(ClassLoader classLoader, String[] upgradeProcessClassNames) {
        ArrayList<UpgradeProcess> upgradeProcesses = new ArrayList<UpgradeProcess>();
        for (String upgradeProcessClassName : upgradeProcessClassNames) {
            if (_log.isDebugEnabled()) {
                _log.debug("Initializing upgrade " + upgradeProcessClassName);
            }
            UpgradeProcess upgradeProcess = null;
            try {
                Class<?> clazz = classLoader.loadClass(upgradeProcessClassName);
                upgradeProcess = (UpgradeProcess)clazz.newInstance();
            }
            catch (Exception e) {
                _log.error("Unable to initialize upgrade " + upgradeProcessClassName);
                continue;
            }
            upgradeProcesses.add(upgradeProcess);
        }
        return upgradeProcesses;
    }

    public static boolean isCreateIGImageDocumentType() {
        return _createIGImageDocumentType;
    }

    public static void setCreateIGImageDocumentType(boolean createIGImageDocumentType) {
        _createIGImageDocumentType = createIGImageDocumentType;
    }

    public static boolean upgradeProcess(int buildNumber, List<UpgradeProcess> upgradeProcesses) throws UpgradeException {
        return UpgradeProcessUtil.upgradeProcess(buildNumber, upgradeProcesses, _INDEX_ON_UPGRADE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upgradeProcess(int buildNumber, List<UpgradeProcess> upgradeProcesses, boolean indexOnUpgrade) throws UpgradeException {
        boolean ranUpgradeProcess = false;
        boolean tempIndexReadOnly = IndexWriterHelperUtil.isIndexReadOnly();
        if (indexOnUpgrade) {
            IndexWriterHelperUtil.setIndexReadOnly(true);
        }
        try {
            for (UpgradeProcess upgradeProcess : upgradeProcesses) {
                boolean tempRanUpgradeProcess = UpgradeProcessUtil._upgradeProcess(buildNumber, upgradeProcess);
                if (!tempRanUpgradeProcess) continue;
                ranUpgradeProcess = true;
            }
        }
        finally {
            IndexWriterHelperUtil.setIndexReadOnly(tempIndexReadOnly);
            if (ranUpgradeProcess) {
                MultiVMPoolUtil.clear();
            }
        }
        return ranUpgradeProcess;
    }

    private static boolean _upgradeProcess(int buildNumber, UpgradeProcess upgradeProcess) throws UpgradeException {
        Class<?> clazz = upgradeProcess.getClass();
        if (upgradeProcess.getThreshold() == 0 || upgradeProcess.getThreshold() > buildNumber) {
            if (_log.isDebugEnabled()) {
                _log.debug("Running upgrade " + clazz.getName());
            }
            upgradeProcess.upgrade();
            if (_log.isDebugEnabled()) {
                _log.debug("Finished upgrade " + clazz.getName());
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Upgrade threshold " + upgradeProcess.getThreshold() + " will not trigger upgrade");
            _log.debug("Skipping upgrade " + clazz.getName());
        }
        return false;
    }
}

