/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.service.RetryAcceptor;
import java.util.Map;

public class ExceptionRetryAcceptor
implements RetryAcceptor {
    public static final String EXCEPTION_NAME = "EXCEPTION_NAME";

    @Override
    public boolean acceptException(Throwable t, Map<String, String> propertyMap) {
        String name = propertyMap.get(EXCEPTION_NAME);
        if (name == null) {
            throw new IllegalArgumentException("Missing property EXCEPTION_NAME");
        }
        while (true) {
            Class<?> clazz = t.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                Class<?> exceptionClass = classLoader.loadClass(name);
                if (exceptionClass.isInstance(t)) {
                    return true;
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            Throwable cause = t.getCause();
            if (t == cause || cause == null) break;
            t = cause;
        }
        return false;
    }

    @Override
    public boolean acceptResult(Object returnValue, Map<String, String> propertyMap) {
        return false;
    }
}

