/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.log;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.log.LoggingProcessCallable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public class ProcessOutputStream
extends UnsyncByteArrayOutputStream {
    private final boolean _error;
    private byte[] _logPrefix;
    private final ObjectOutputStream _objectOutputStream;

    public ProcessOutputStream(ObjectOutputStream objectOutputStream) {
        this(objectOutputStream, false);
    }

    public ProcessOutputStream(ObjectOutputStream objectOutputStream, boolean error) {
        this._objectOutputStream = objectOutputStream;
        this._error = error;
    }

    @Override
    public void close() throws IOException {
        this._objectOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (this.index > 0) {
                byte[] bytes = this.toByteArray();
                this.reset();
                byte[] logData = new byte[this._logPrefix.length + bytes.length];
                System.arraycopy(this._logPrefix, 0, logData, 0, this._logPrefix.length);
                System.arraycopy(bytes, 0, logData, this._logPrefix.length, bytes.length);
                this._objectOutputStream.writeObject(new LoggingProcessCallable(logData, this._error));
            }
            this._objectOutputStream.flush();
            this._objectOutputStream.reset();
        }
    }

    public void setLogPrefix(byte[] logPrefix) {
        this._logPrefix = logPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProcessCallable(ProcessCallable<?> processCallable) throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            try {
                this._objectOutputStream.writeObject(processCallable);
            }
            catch (NotSerializableException nse) {
                this._objectOutputStream.reset();
                throw nse;
            }
            finally {
                this._objectOutputStream.flush();
            }
        }
    }
}

