/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.FileFilter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public abstract class DLPreviewableProcessor
implements DLProcessor {
    public static final String PREVIEW_PATH = "document_preview/";
    public static final String PREVIEW_TMP_PATH = SystemProperties.get("java.io.tmpdir") + "/liferay/" + "document_preview/";
    public static final long REPOSITORY_ID = 0L;
    public static final int THUMBNAIL_INDEX_CUSTOM_1 = 1;
    public static final int THUMBNAIL_INDEX_CUSTOM_2 = 2;
    public static final int THUMBNAIL_INDEX_DEFAULT = 0;
    public static final String THUMBNAIL_PATH = "document_thumbnail/";
    public static final String THUMBNAIL_TMP_PATH = SystemProperties.get("java.io.tmpdir") + "/liferay/" + "document_thumbnail/";
    protected Map<String, Future<?>> futures = new ConcurrentHashMap();
    private static final Log _log = LogFactoryUtil.getLog(DLPreviewableProcessor.class);

    public static void deleteFiles() {
        long[] companyIds;
        for (long companyId : companyIds = PortalUtil.getCompanyIds()) {
            DLStoreUtil.deleteDirectory(companyId, 0L, PREVIEW_PATH);
            DLStoreUtil.deleteDirectory(companyId, 0L, THUMBNAIL_PATH);
        }
    }

    @Override
    public void cleanUp(FileEntry fileEntry) {
        this.deleteFiles(fileEntry, this.getThumbnailType());
    }

    @Override
    public void cleanUp(FileVersion fileVersion) {
        this.deleteFiles(fileVersion, this.getThumbnailType());
    }

    @Override
    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (sourceFileVersion.getFileVersionId() == destinationFileVersion.getFileVersionId()) {
            return;
        }
        this.copyPreviews(sourceFileVersion, destinationFileVersion);
        this.copyThumbnails(sourceFileVersion, destinationFileVersion);
    }

    public void deleteFiles(FileEntry fileEntry, String thumbnailType) {
        this.deleteFiles(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getFileEntryId(), -1L, thumbnailType);
    }

    public void deleteFiles(FileVersion fileVersion, String thumbnailType) {
        this.deleteFiles(fileVersion.getCompanyId(), fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), thumbnailType);
    }

    @Override
    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.doExportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
    }

    @Override
    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.cleanUp(importedFileEntry.getFileVersion());
        this.doImportGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    @Override
    public boolean isSupported(FileVersion fileVersion) {
        if (fileVersion == null) {
            return false;
        }
        if (!DLProcessorRegistryUtil.isPreviewableSize(fileVersion)) {
            return false;
        }
        return this.isSupported(fileVersion.getMimeType());
    }

    @Override
    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this.getFileVersionIds().contains(destinationFileVersion.getFileVersionId())) {
            String processIdentity = Long.toString(destinationFileVersion.getFileVersionId());
            this.destroyProcess(processIdentity);
            this.getFileVersionIds().remove(destinationFileVersion.getFileVersionId());
        }
    }

    protected static String getPathSegment(FileVersion fileVersion, boolean preview) {
        return DLPreviewableProcessor.getPathSegment(fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), preview);
    }

    protected static String getPathSegment(long groupId, long fileEntryId, long fileVersionId, boolean preview) {
        StringBundler sb = null;
        sb = fileVersionId > 0L ? new StringBundler(5) : new StringBundler(3);
        if (preview) {
            sb.append(PREVIEW_PATH);
        } else {
            sb.append(THUMBNAIL_PATH);
        }
        sb.append(groupId);
        sb.append(DLUtil.getDividedPath(fileEntryId));
        if (fileVersionId > 0L) {
            sb.append("/");
            sb.append(fileVersionId);
        }
        return sb.toString();
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, File srcFile) throws PortalException {
        DLStoreUtil.addDirectory(companyId, 0L, dirName);
        DLStoreUtil.addFile(companyId, 0L, filePath, false, srcFile);
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, InputStream is) throws PortalException {
        DLStoreUtil.addDirectory(companyId, 0L, dirName);
        DLStoreUtil.addFile(companyId, 0L, filePath, false, is);
    }

    protected void copyPreviews(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        try {
            String[] previewTypes;
            for (String previewType : previewTypes = this.getPreviewTypes()) {
                if (!this.hasPreview(sourceFileVersion, previewType) || this.hasPreview(destinationFileVersion, previewType)) continue;
                String previewFilePath = this.getPreviewFilePath(destinationFileVersion, previewType);
                InputStream is = this.doGetPreviewAsStream(sourceFileVersion, previewType);
                this.addFileToStore(destinationFileVersion.getCompanyId(), PREVIEW_PATH, previewFilePath, is);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    protected void copyThumbnail(FileVersion sourceFileVersion, FileVersion destinationFileVersion, int index) {
        try {
            if (this.isThumbnailEnabled(index) && this.hasThumbnail(sourceFileVersion, index) && !this.hasThumbnail(destinationFileVersion, index)) {
                InputStream is = this.doGetThumbnailAsStream(sourceFileVersion, index);
                String thumbnailFilePath = this.getThumbnailFilePath(destinationFileVersion, this.getThumbnailType(destinationFileVersion), index);
                this.addFileToStore(destinationFileVersion.getCompanyId(), THUMBNAIL_PATH, thumbnailFilePath, is);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    protected void copyThumbnails(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        this.copyThumbnail(sourceFileVersion, destinationFileVersion, 0);
        this.copyThumbnail(sourceFileVersion, destinationFileVersion, 1);
        this.copyThumbnail(sourceFileVersion, destinationFileVersion, 2);
    }

    protected void deleteFiles(long companyId, long groupId, long fileEntryId, long fileVersionId, String thumbnailType) {
        this.deletePreviews(companyId, groupId, fileEntryId, fileVersionId);
        this.deleteThumbnails(companyId, groupId, fileEntryId, fileVersionId, thumbnailType);
    }

    protected void deletePreviews(long companyId, long groupId, long fileEntryId, long fileVersionId) {
        String previewFilePath = this.getPreviewFilePath(groupId, fileEntryId, fileVersionId, null);
        DLStoreUtil.deleteDirectory(companyId, 0L, previewFilePath);
    }

    protected void deleteThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, String thumbnailType, int index) {
        try {
            String thumbnailFilePath = this.getThumbnailFilePath(groupId, fileEntryId, fileVersionId, thumbnailType, index);
            DLStoreUtil.deleteDirectory(companyId, 0L, thumbnailFilePath);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void deleteThumbnails(long companyId, long groupId, long fileEntryId, long fileVersionId, String thumbnailType) {
        this.deleteThumbnail(companyId, groupId, fileEntryId, fileVersionId, thumbnailType, 0);
        this.deleteThumbnail(companyId, groupId, fileEntryId, fileVersionId, thumbnailType, 1);
        this.deleteThumbnail(companyId, groupId, fileEntryId, fileVersionId, thumbnailType, 2);
    }

    protected void destroyProcess(String processIdentity) {
        Future<?> future = this.futures.remove(processIdentity);
        if (future != null) {
            future.cancel(true);
            if (_log.isInfoEnabled()) {
                _log.info("Cancellation requested for " + processIdentity);
            }
        }
    }

    protected abstract void doExportGeneratedFiles(PortletDataContext var1, FileEntry var2, Element var3) throws Exception;

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, int index, String type) throws PortalException {
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, String type) throws PortalException {
        return this.doGetPreviewAsStream(fileVersion, 0, type);
    }

    protected int doGetPreviewFileCount(FileVersion fileVersion) throws Exception {
        try {
            String[] fileNames = DLStoreUtil.getFileNames(fileVersion.getCompanyId(), 0L, DLPreviewableProcessor.getPathSegment(fileVersion, true));
            return fileNames.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, int index) throws PortalException {
        return this.doGetPreviewFileSize(fileVersion, index, this.getPreviewType());
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, int index, String type) throws PortalException {
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, String type) throws PortalException {
        return this.doGetPreviewFileSize(fileVersion, 0, type);
    }

    protected InputStream doGetThumbnailAsStream(FileVersion fileVersion, int index) throws PortalException {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, index));
    }

    protected long doGetThumbnailFileSize(FileVersion fileVersion, int index) throws PortalException {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, index));
    }

    protected abstract void doImportGeneratedFiles(PortletDataContext var1, FileEntry var2, FileEntry var3, Element var4) throws Exception;

    protected void exportBinary(PortletDataContext portletDataContext, Element fileEntryElement, FileVersion fileVersion, InputStream is, String binPath, String binPathName) {
        fileEntryElement.addAttribute(binPathName, binPath);
        if (is == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("No input stream found for file entry " + fileVersion.getFileEntryId());
            }
            fileEntryElement.detach();
            return;
        }
        portletDataContext.addZipEntry(binPath, is);
    }

    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType) throws Exception {
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement, binPathSuffix, previewType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        if (portletDataContext.isPerformDirectBinaryImport()) {
            return;
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.hasPreview(fileVersion, previewType)) {
            if (_log.isWarnEnabled()) {
                _log.warn("No preview found for file entry " + fileEntry.getFileEntryId());
            }
            return;
        }
        String binPathSegment = null;
        binPathSegment = fileIndex < 0 ? previewType : Integer.toString(fileIndex + 1);
        String binPath = this.getBinPath(portletDataContext, fileEntry, binPathSegment);
        StringBundler sb = new StringBundler(4);
        sb.append("bin-path-preview-");
        sb.append(binPathSegment);
        sb.append("-");
        sb.append(binPathSuffix);
        String binPathName = sb.toString();
        fileEntryElement.addAttribute(binPathName, binPath);
        InputStream is = null;
        try {
            is = fileIndex < 0 ? this.doGetPreviewAsStream(fileVersion, previewType) : this.doGetPreviewAsStream(fileVersion, fileIndex + 1, previewType);
            this.exportBinary(portletDataContext, fileEntryElement, fileVersion, is, binPath, binPathName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportThumbnail(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathName, int index) throws PortalException {
        if (!this.isThumbnailEnabled(index)) {
            return;
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.hasThumbnail(fileVersion, index)) {
            if (_log.isWarnEnabled()) {
                _log.warn("No thumbnail found for file entry " + fileEntry.getFileEntryId());
            }
            return;
        }
        InputStream is = null;
        try {
            is = this.doGetThumbnailAsStream(fileVersion, index);
            String binPath = this.getBinPath(portletDataContext, fileEntry, index);
            fileEntryElement.addAttribute(binPathName, binPath);
            this.exportBinary(portletDataContext, fileEntryElement, fileVersion, is, binPath, binPathName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    protected void exportThumbnails(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix) throws PortalException {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-default-" + binPathSuffix, 0);
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-custom-1-" + binPathSuffix, 1);
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-custom-2-" + binPathSuffix, 2);
        }
    }

    protected String getBinPath(PortletDataContext portletDataContext, FileEntry fileEntry, int index) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getPortletPath(portletDataContext, "com_liferay_document_library_web_portlet_DLPortlet"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(THUMBNAIL_PATH);
        sb.append(fileEntry.getVersion());
        sb.append("/");
        sb.append(index);
        return sb.toString();
    }

    protected String getBinPath(PortletDataContext portletDataContext, FileEntry fileEntry, String type) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getPortletPath(portletDataContext, "com_liferay_document_library_web_portlet_DLPortlet"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(PREVIEW_PATH);
        sb.append(fileEntry.getVersion());
        sb.append("/");
        sb.append(type);
        return sb.toString();
    }

    protected abstract List<Long> getFileVersionIds();

    protected String getPreviewFilePath(FileVersion fileVersion) {
        return this.getPreviewFilePath(fileVersion, 0);
    }

    protected String getPreviewFilePath(FileVersion fileVersion, int index) {
        return this.getPreviewFilePath(fileVersion, index, this.getPreviewType());
    }

    protected String getPreviewFilePath(FileVersion fileVersion, int index, String type) {
        return this.getPreviewFilePath(fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), index, type);
    }

    protected String getPreviewFilePath(FileVersion fileVersion, String type) {
        return this.getPreviewFilePath(fileVersion, 0, type);
    }

    protected String getPreviewFilePath(long groupId, long fileEntryId, long fileVersionId, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(5) : new StringBundler(3);
        sb.append(DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, true));
        if (index > 0) {
            sb.append("/");
            sb.append(index - 1);
        }
        if (Validator.isNotNull(type)) {
            sb.append(".");
            sb.append(type);
        }
        return sb.toString();
    }

    protected String getPreviewFilePath(long groupId, long fileEntryId, long fileVersionId, String type) {
        return this.getPreviewFilePath(groupId, fileEntryId, fileVersionId, 0, type);
    }

    protected File getPreviewTempFile(String id) {
        return this.getPreviewTempFile(id, 0);
    }

    protected File getPreviewTempFile(String id, int index) {
        return this.getPreviewTempFile(id, index, this.getPreviewType());
    }

    protected File getPreviewTempFile(String id, int index, String type) {
        String previewTempFilePath = this.getPreviewTempFilePath(id, index, type);
        return new File(previewTempFilePath);
    }

    protected File getPreviewTempFile(String id, String type) {
        return this.getPreviewTempFile(id, 0, type);
    }

    protected int getPreviewTempFileCount(FileVersion fileVersion) {
        return this.getPreviewTempFileCount(fileVersion, this.getPreviewType());
    }

    protected int getPreviewTempFileCount(FileVersion fileVersion, String type) {
        String tempFileId = DLUtil.getTempFileId(fileVersion.getFileEntryId(), fileVersion.getVersion());
        StringBundler sb = new StringBundler(5);
        sb.append(tempFileId);
        sb.append("-");
        sb.append("(.*)");
        if (Validator.isNotNull(type)) {
            sb.append(".");
            sb.append(type);
        }
        File dir = new File(PREVIEW_TMP_PATH);
        File[] files = dir.listFiles(new FileFilter(sb.toString()));
        if (_log.isDebugEnabled()) {
            for (File file : files) {
                _log.debug("Preview page for " + tempFileId + " " + file);
            }
        }
        return files.length;
    }

    protected String getPreviewTempFilePath(String id) {
        return this.getPreviewTempFilePath(id, 0);
    }

    protected String getPreviewTempFilePath(String id, int index) {
        return this.getPreviewTempFilePath(id, index, this.getPreviewType());
    }

    protected String getPreviewTempFilePath(String id, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(6) : new StringBundler(4);
        sb.append(PREVIEW_TMP_PATH);
        sb.append(id);
        if (index > 0) {
            sb.append("-");
            sb.append(index - 1);
        } else if (index == -1) {
            sb.append("-%d");
        }
        if (Validator.isNotNull(type)) {
            sb.append(".");
            sb.append(type);
        }
        return sb.toString();
    }

    protected String getPreviewTempFilePath(String id, String type) {
        return this.getPreviewTempFilePath(id, 0, type);
    }

    protected String getPreviewType() {
        return this.getPreviewType(null);
    }

    protected abstract String getPreviewType(FileVersion var1);

    protected String getPreviewType(int index) {
        String[] previewTypes = this.getPreviewTypes();
        if (previewTypes != null && previewTypes.length > index) {
            return previewTypes[index];
        }
        return this.getPreviewType();
    }

    protected String[] getPreviewTypes() {
        return new String[]{this.getPreviewType()};
    }

    protected String getThumbnailFilePath(FileVersion fileVersion, int index) {
        return this.getThumbnailFilePath(fileVersion, this.getThumbnailType(), index);
    }

    protected String getThumbnailFilePath(FileVersion fileVersion, String type, int index) {
        return this.getThumbnailFilePath(fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), type, index);
    }

    protected String getThumbnailFilePath(long groupId, long fileEntryId, long fileVersionId, String thumbnailType, int index) {
        StringBundler sb = new StringBundler(5);
        sb.append(DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, false));
        if (index != 0) {
            sb.append("-");
            sb.append(index);
        }
        if (fileVersionId > 0L && Validator.isNotNull(thumbnailType)) {
            sb.append(".");
            sb.append(thumbnailType);
        }
        return sb.toString();
    }

    protected File getThumbnailTempFile(String id) {
        return this.getThumbnailTempFile(id, this.getThumbnailType());
    }

    protected File getThumbnailTempFile(String id, String type) {
        String thumbnailTempFilePath = this.getThumbnailTempFilePath(id, type);
        return new File(thumbnailTempFilePath);
    }

    protected String getThumbnailTempFilePath(String id) {
        return this.getThumbnailTempFilePath(id, this.getThumbnailType());
    }

    protected String getThumbnailTempFilePath(String id, String type) {
        StringBundler sb = new StringBundler(4);
        sb.append(THUMBNAIL_TMP_PATH);
        sb.append(id);
        if (Validator.isNotNull(type)) {
            sb.append(".");
            sb.append(type);
        }
        return sb.toString();
    }

    protected String getThumbnailType() {
        return this.getThumbnailType(null);
    }

    protected abstract String getThumbnailType(FileVersion var1);

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, type);
        return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, previewFilePath);
    }

    protected boolean hasPreviews(FileVersion fileVersion) throws Exception {
        String[] previewTypes;
        int count = 0;
        for (String previewType : previewTypes = this.getPreviewTypes()) {
            if (!this.hasPreview(fileVersion, previewType)) continue;
            ++count;
        }
        return count == previewTypes.length;
    }

    protected boolean hasThumbnail(FileVersion fileVersion, int index) {
        try {
            String imageType = this.getThumbnailType(fileVersion);
            return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, imageType, index));
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    protected boolean hasThumbnails(FileVersion fileVersion) {
        return !(this.isThumbnailEnabled(0) && !this.hasThumbnail(fileVersion, 0) || this.isThumbnailEnabled(1) && !this.hasThumbnail(fileVersion, 1)) && (!this.isThumbnailEnabled(2) || this.hasThumbnail(fileVersion, 2));
    }

    protected void importPreview(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix, String previewType) throws Exception {
        this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, binPathSuffix, previewType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void importPreview(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.importPreviewFromLAR(portletDataContext, importedFileEntry, fileEntryElement, binPathSuffix, previewType, fileIndex);
            return;
        }
        FileVersion importedFileVersion = importedFileEntry.getFileVersion();
        String previewFilePath = this.getPreviewFilePath(importedFileVersion, previewType);
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.hasPreview(fileVersion, previewType)) {
            return;
        }
        InputStream is = null;
        try {
            is = fileIndex < 0 ? this.doGetPreviewAsStream(fileVersion, previewType) : this.doGetPreviewAsStream(fileVersion, fileIndex, previewType);
            this.addFileToStore(portletDataContext.getCompanyId(), PREVIEW_PATH, previewFilePath, is);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPreviewFromLAR(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        InputStream is;
        FileVersion fileVersion;
        block3: {
            fileVersion = fileEntry.getFileVersion();
            String binPathSegment = null;
            binPathSegment = fileIndex < 0 ? previewType : Integer.toString(fileIndex + 1);
            StringBundler sb = new StringBundler(4);
            sb.append("bin-path-preview-");
            sb.append(binPathSegment);
            sb.append("-");
            sb.append(binPathSuffix);
            String binPathName = sb.toString();
            String binPath = fileEntryElement.attributeValue(binPathName);
            is = null;
            try {
                is = portletDataContext.getZipEntryAsInputStream(binPath);
                if (is != null) break block3;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(is);
                throw throwable;
            }
            StreamUtil.cleanUp(is);
            return;
        }
        String previewFilePath = null;
        previewFilePath = fileIndex < 0 ? this.getPreviewFilePath(fileVersion, previewType) : this.getPreviewFilePath(fileVersion, fileIndex + 1);
        this.addFileToStore(portletDataContext.getCompanyId(), PREVIEW_PATH, previewFilePath, is);
        StreamUtil.cleanUp(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void importThumbnail(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathName, int index) throws Exception {
        if (!this.isThumbnailEnabled(index)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.importThumbnailFromLAR(portletDataContext, importedFileEntry, fileEntryElement, binPathName, index);
            return;
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.hasThumbnail(fileVersion, index)) {
            return;
        }
        InputStream is = null;
        try {
            is = this.doGetThumbnailAsStream(fileVersion, index);
            FileVersion importedFileVersion = importedFileEntry.getFileVersion();
            String thumbnailFilePath = this.getThumbnailFilePath(importedFileVersion, this.getThumbnailType(importedFileVersion), index);
            this.addFileToStore(portletDataContext.getCompanyId(), THUMBNAIL_PATH, thumbnailFilePath, is);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importThumbnailFromLAR(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathName, int index) throws Exception {
        InputStream is;
        FileVersion fileVersion;
        block3: {
            fileVersion = fileEntry.getFileVersion();
            String binPath = fileEntryElement.attributeValue(binPathName);
            is = null;
            try {
                is = portletDataContext.getZipEntryAsInputStream(binPath);
                if (is != null) break block3;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(is);
                throw throwable;
            }
            StreamUtil.cleanUp(is);
            return;
        }
        String thumbnailFilePath = this.getThumbnailFilePath(fileVersion, this.getThumbnailType(fileVersion), index);
        this.addFileToStore(portletDataContext.getCompanyId(), THUMBNAIL_PATH, thumbnailFilePath, is);
        StreamUtil.cleanUp(is);
    }

    protected void importThumbnails(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix) throws Exception {
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-default-" + binPathSuffix, 0);
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-custom-1-" + binPathSuffix, 1);
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-custom-2-" + binPathSuffix, 2);
    }

    protected boolean isThumbnailEnabled(int index) {
        if (index == 0 && GetterUtil.getBoolean(PropsUtil.get("dl.file.entry.thumbnail.enabled"))) {
            return true;
        }
        if (index == 1 && (PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.width") > 0)) {
            return true;
        }
        return index == 2 && (PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.width") > 0);
    }

    protected void sendGenerationMessage(String destinationName, FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        Object[] payload = new Object[]{sourceFileVersion, destinationFileVersion};
        MessageBusUtil.sendMessage(destinationName, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeThumbnailImage(FileVersion fileVersion, RenderedImage renderedImage, int index) throws Exception {
        if (!this.isThumbnailEnabled(index) || this.hasThumbnail(fileVersion, index)) {
            return;
        }
        String type = this.getThumbnailType(fileVersion);
        String maxHeightPropsKey = "dl.file.entry.thumbnail.max.height";
        String maxWidthPropsKey = "dl.file.entry.thumbnail.max.width";
        if (index == 1) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom1.max.height";
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom1.max.width";
        } else if (index == 2) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom2.max.height";
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom2.max.width";
        }
        RenderedImage thumbnailRenderedImage = ImageToolUtil.scale(renderedImage, PrefsPropsUtil.getInteger(maxHeightPropsKey), PrefsPropsUtil.getInteger(maxWidthPropsKey));
        byte[] bytes = ImageToolUtil.getBytes(thumbnailRenderedImage, type);
        File file = null;
        try {
            file = FileUtil.createTempFile(bytes);
            this.addFileToStore(fileVersion.getCompanyId(), THUMBNAIL_PATH, this.getThumbnailFilePath(fileVersion, type, index), file);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        ImageBag imageBag = ImageToolUtil.read(file);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        this.storeThumbnailImages(fileVersion, renderedImage);
    }

    protected void storeThumbnailImages(FileVersion fileVersion, RenderedImage renderedImage) throws Exception {
        this.storeThumbnailImage(fileVersion, renderedImage, 0);
        this.storeThumbnailImage(fileVersion, renderedImage, 1);
        this.storeThumbnailImage(fileVersion, renderedImage, 2);
    }
}

