/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.liferay.css.builder.CSSBuilder;
import com.liferay.css.builder.CSSBuilderArgs;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.util.ArrayList;

public class CSSBuilderInvoker {
    public static void invoke(File baseDir, CSSBuilderArgs cssBuilderArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        String[] dirNames = cssBuilderArgs.getDirNames();
        if (dirNames.length == 1) {
            args.add("sass.dir=" + dirNames[0]);
        } else {
            for (int i = 0; i < dirNames.length; ++i) {
                args.add("sass.dir." + i + "=" + dirNames[i]);
            }
        }
        args.add("sass.docroot.dir=" + CSSBuilderInvoker._getAbsolutePath(baseDir, cssBuilderArgs.getDocrootDirName()));
        args.add("sass.generate.source.map=" + cssBuilderArgs.isGenerateSourceMap());
        args.add("sass.output.dir=" + cssBuilderArgs.getOutputDirName());
        args.add("sass.portal.common.path=" + CSSBuilderInvoker._getAbsolutePath(baseDir, cssBuilderArgs.getPortalCommonPath()));
        args.add("sass.precision=" + cssBuilderArgs.getPrecision());
        Object[] rtlExcludedPathRegexps = cssBuilderArgs.getRtlExcludedPathRegexps();
        if (rtlExcludedPathRegexps != null && rtlExcludedPathRegexps.length > 0) {
            args.add("sass.rtl.excluded.path.regexps=" + StringUtil.merge(rtlExcludedPathRegexps));
        }
        args.add("sass.compiler.class.name=" + cssBuilderArgs.getSassCompilerClassName());
        CSSBuilder.main(args.toArray(new String[args.size()]));
    }

    private static String _getAbsolutePath(File baseDir, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(baseDir, fileName);
        }
        return StringUtil.replace(file.getAbsolutePath(), '\\', '/');
    }
}

