/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sass.compiler.jni.internal;

import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.jni.internal.JniSassCompilerException;
import com.liferay.sass.compiler.jni.internal.libsass.LiferaysassLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import org.bridj.Platform;
import org.bridj.Pointer;

public class JniSassCompiler
implements SassCompiler {
    private static final int _PRECISION_DEFAULT = 5;
    private final int _precision;
    private final String _tmpDirName;

    public JniSassCompiler() {
        this(5);
    }

    public JniSassCompiler(int precision) {
        this(precision, System.getProperty("java.io.tmpdir"));
    }

    public JniSassCompiler(int precision, String tmpDirName) {
        Platform.addEmbeddedLibraryResourceRoot("/");
        this._precision = precision;
        this._tmpDirName = tmpDirName;
    }

    public String compileFile(String inputFileName, String includeDirName) throws JniSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, false, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap) throws JniSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, generateSourceMap, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JniSassCompilerException {
        Pointer<LiferaysassLibrary.Sass_File_Context> sassFileContextPointer = null;
        try {
            Pointer<LiferaysassLibrary.Sass_Context> sassContextPointer;
            int errorStatus;
            File inputFile = new File(inputFileName);
            String includeDirNames = includeDirName + File.pathSeparator + inputFile.getParent();
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = this.getOutputFileName(inputFileName) + ".map";
            }
            if ((errorStatus = LiferaysassLibrary.sassContextGetErrorStatus(sassContextPointer = LiferaysassLibrary.sassFileContextGetContext(sassFileContextPointer = this.createSassFileContext(inputFileName, includeDirNames, generateSourceMap, sourceMapFileName)))) != 0) {
                Pointer<Byte> errorMessagePointer = LiferaysassLibrary.sassContextGetErrorMessage(sassContextPointer);
                throw new JniSassCompilerException(errorMessagePointer.getCString());
            }
            Pointer<Byte> outputPointer = LiferaysassLibrary.sassContextGetOutputString(sassContextPointer);
            if (generateSourceMap) {
                try {
                    File sourceMapFile = new File(sourceMapFileName);
                    Pointer<Byte> sourceMapOutputPointer = LiferaysassLibrary.sassContextGetSourceMapString(sassContextPointer);
                    this.write(sourceMapFile, sourceMapOutputPointer.getCString());
                }
                catch (Exception e) {
                    System.out.println("Unable to create source map");
                }
            }
            if (outputPointer == null) {
                throw new JniSassCompilerException("Null output");
            }
            String string = outputPointer.getCString();
            return string;
        }
        finally {
            try {
                if (sassFileContextPointer != null) {
                    LiferaysassLibrary.sassDeleteFileContext(sassFileContextPointer);
                }
            }
            catch (Throwable t) {
                throw new JniSassCompilerException(t);
            }
        }
    }

    public String compileString(String input, String includeDirName) throws JniSassCompilerException {
        return this.compileString(input, "", includeDirName, false);
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap) throws JniSassCompilerException {
        return this.compileString(input, inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JniSassCompilerException {
        try {
            int index;
            if (inputFileName == null || inputFileName.equals("")) {
                inputFileName = this._tmpDirName + File.separator + "tmp.scss";
                if (generateSourceMap) {
                    System.out.println("Source maps require a valid file name");
                    generateSourceMap = false;
                }
            }
            if ((index = inputFileName.lastIndexOf(File.separatorChar)) == -1 && File.separatorChar != '/') {
                index = inputFileName.lastIndexOf(47);
            }
            String dirName = inputFileName.substring(0, ++index);
            String fileName = inputFileName.substring(index);
            String outputFileName = this.getOutputFileName(fileName);
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = dirName + outputFileName + ".map";
            }
            File tempFile = new File(dirName, "tmp.scss");
            tempFile.deleteOnExit();
            this.write(tempFile, input);
            String output = this.compileFile(tempFile.getCanonicalPath(), includeDirName, generateSourceMap, sourceMapFileName);
            if (generateSourceMap) {
                File sourceMapFile = new File(sourceMapFileName);
                String sourceMapContent = new String(Files.readAllBytes(sourceMapFile.toPath()));
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.scss", fileName);
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.css", outputFileName);
                this.write(sourceMapFile, sourceMapContent);
            }
            return output;
        }
        catch (Throwable t) {
            throw new JniSassCompilerException(t);
        }
    }

    protected Pointer<LiferaysassLibrary.Sass_File_Context> createSassFileContext(String inputFileName, String includeDirNames, boolean generateSourceMap, String sourceMapFileName) {
        Pointer<LiferaysassLibrary.Sass_File_Context> sassFileContextPointer = LiferaysassLibrary.sassMakeFileContext(this.toPointer(inputFileName));
        Pointer<LiferaysassLibrary.Sass_Options> sassOptionsPointer = LiferaysassLibrary.sassMakeOptions();
        LiferaysassLibrary.sassOptionSetIncludePath(sassOptionsPointer, this.toPointer(includeDirNames));
        LiferaysassLibrary.sassOptionSetInputPath(sassOptionsPointer, this.toPointer(inputFileName));
        LiferaysassLibrary.sassOptionSetOutputPath(sassOptionsPointer, this.toPointer(""));
        LiferaysassLibrary.sassOptionSetOutputStyle(sassOptionsPointer, LiferaysassLibrary.Sass_Output_Style.SASS_STYLE_NESTED);
        LiferaysassLibrary.sassOptionSetPrecision(sassOptionsPointer, this._precision);
        LiferaysassLibrary.sassOptionSetSourceComments(sassOptionsPointer, false);
        if (generateSourceMap) {
            LiferaysassLibrary.sassOptionSetSourceMapContents(sassOptionsPointer, false);
            LiferaysassLibrary.sassOptionSetSourceMapEmbed(sassOptionsPointer, false);
            LiferaysassLibrary.sassOptionSetSourceMapFile(sassOptionsPointer, this.toPointer(sourceMapFileName));
            LiferaysassLibrary.sassOptionSetOmitSourceMapUrl(sassOptionsPointer, false);
        }
        LiferaysassLibrary.sassFileContextSetOptions(sassFileContextPointer, sassOptionsPointer);
        LiferaysassLibrary.sassCompileFileContext(sassFileContextPointer);
        return sassFileContextPointer;
    }

    protected String getOutputFileName(String fileName) {
        return fileName.replaceAll("scss$", "css");
    }

    protected Pointer<Byte> toPointer(String s) {
        return Pointer.pointerToCString(s);
    }

    protected void write(File file, String string) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            parentFile.mkdirs();
            file.createNewFile();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");){
            writer.write(string);
        }
    }
}

