/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBBanLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBDiscussionLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;

@OSGiBeanProperties(property={"model.class.name=com.liferay.message.boards.kernel.model.MBDiscussion"})
public class MBDiscussionPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) throws PortalException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException {
        if (!MBDiscussionPermission.contains(permissionChecker, messageId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MBMessage.class.getName(), messageId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) {
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        String portletId = PortletProviderUtil.getPortletId((String)MBDiscussion.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)className, (long)classPK, (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.fetchDiscussion((String)className, (long)classPK);
        if (mbDiscussion == null) {
            return false;
        }
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        if (!resourceActions.contains(actionId)) {
            return true;
        }
        if (mbDiscussion.getUserId() > 0L && permissionChecker.hasOwnerPermission(companyId, className, classPK, mbDiscussion.getUserId(), actionId)) {
            return true;
        }
        hasPermission = BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)groupId, (String)className, (long)classPK, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException {
        Boolean hasPermission;
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        String className = message.getClassName();
        if (className.equals(WorkflowInstance.class.getName())) {
            return permissionChecker.hasPermission(message.getGroupId(), "com_liferay_portal_workflow_definition_web_portlet_WorkflowDefinitionPortlet", message.getGroupId(), "VIEW");
        }
        if (PropsValues.DISCUSSION_COMMENTS_ALWAYS_EDITABLE_BY_OWNER && permissionChecker.getUserId() == message.getUserId()) {
            return true;
        }
        if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
            return hasPermission;
        }
        return MBDiscussionPermission.contains(permissionChecker, message.getCompanyId(), message.getGroupId(), className, message.getClassPK(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.getMBDiscussion((long)primaryKey);
        MBDiscussionPermission.check(permissionChecker, mbDiscussion.getCompanyId(), groupId, mbDiscussion.getClassName(), mbDiscussion.getClassPK(), actionId);
    }
}

