/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.layouts.admin.kernel.util.Sitemap;
import com.liferay.layouts.admin.kernel.util.SitemapURLProvider;
import com.liferay.layouts.admin.kernel.util.SitemapURLProviderRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@DoPrivileged
public class SitemapImpl
implements Sitemap {
    public void addURLElement(Element element, String url, UnicodeProperties typeSettingsProperties, Date modifiedDate, String canonicalURL, Map<Locale, String> alternateURLs) {
        Element urlElement = element.addElement("url");
        Element locElement = urlElement.addElement("loc");
        locElement.addText(this.encodeXML(url));
        if (typeSettingsProperties == null) {
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                Element changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                Element priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        } else {
            Element priorityElement;
            Element changefreqElement;
            String changefreq = typeSettingsProperties.getProperty("sitemap-changefreq");
            if (Validator.isNotNull((String)changefreq)) {
                changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(changefreq);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            String priority = typeSettingsProperties.getProperty("sitemap-priority");
            if (Validator.isNotNull((String)priority)) {
                priorityElement = urlElement.addElement("priority");
                priorityElement.addText(priority);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        }
        if (modifiedDate != null) {
            Element modifiedDateElement = urlElement.addElement("lastmod");
            DateFormat iso8601DateFormat = DateUtil.getISO8601Format();
            modifiedDateElement.addText(iso8601DateFormat.format(modifiedDate));
        }
        if (alternateURLs != null) {
            for (Map.Entry<Locale, String> entry : alternateURLs.entrySet()) {
                Locale locale = entry.getKey();
                String href = entry.getValue();
                Element alternateURLElement = urlElement.addElement("xhtml:link", "http://www.w3.org/1999/xhtml");
                alternateURLElement.addAttribute("href", href);
                alternateURLElement.addAttribute("hreflang", LocaleUtil.toW3cLanguageId((Locale)locale));
                alternateURLElement.addAttribute("rel", "alternate");
            }
            Element alternateURLElement = urlElement.addElement("xhtml:link", "http://www.w3.org/1999/xhtml");
            alternateURLElement.addAttribute("rel", "alternate");
            alternateURLElement.addAttribute("hreflang", "x-default");
            alternateURLElement.addAttribute("href", canonicalURL);
        }
    }

    public String encodeXML(String input) {
        return StringUtil.replace((String)input, (char[])new char[]{'&', '<', '>', '\'', '\"'}, (String[])new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"});
    }

    public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
        for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)layout.getGroupId())) {
            String alternateURL = PortalUtil.getAlternateURL((String)canonicalURL, (ThemeDisplay)themeDisplay, (Locale)availableLocale, (Layout)layout);
            alternateURLs.put(availableLocale, alternateURL);
        }
        return alternateURLs;
    }

    public String getSitemap(long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException {
        Document document = SAXReaderUtil.createDocument();
        document.setXMLEncoding("UTF-8");
        Element rootElement = document.addElement("urlset", "http://www.sitemaps.org/schemas/sitemap/0.9");
        rootElement.addAttribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        List sitemapURLProviders = SitemapURLProviderRegistryUtil.getSitemapURLProviders();
        for (SitemapURLProvider sitemapURLProvider : sitemapURLProviders) {
            sitemapURLProvider.visitLayoutSet(rootElement, layoutSet, themeDisplay);
        }
        return document.asXML();
    }
}

