/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLFileVersionPolicy;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class DLFileVersionPolicyImpl
implements DLFileVersionPolicy {
    @BeanReference(type=DLFileEntryMetadataLocalService.class)
    protected DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService;
    @BeanReference(type=DLFileVersionPersistence.class)
    protected DLFileVersionPersistence dlFileVersionPersistence;
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionPolicyImpl.class);
    private final ServiceTrackerList<DLFileVersionPolicy> _serviceTrackerList = ServiceTrackerCollections.openList(DLFileVersionPolicy.class);

    public void destroy() {
        this._serviceTrackerList.close();
    }

    public boolean isKeepFileVersionLabel(DLFileVersion lastDLFileVersion, DLFileVersion latestDLFileVersion, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        for (DLFileVersionPolicy dlFileVersionPolicy : this._serviceTrackerList) {
            if (dlFileVersionPolicy == this || dlFileVersionPolicy.isKeepFileVersionLabel(lastDLFileVersion, latestDLFileVersion, majorVersion, serviceContext)) continue;
            return false;
        }
        return this.isKeepFileVersionLabel(lastDLFileVersion.getFileEntry(), lastDLFileVersion, latestDLFileVersion, majorVersion, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isKeepFileVersionLabel(DLFileEntry dlFileEntry, DLFileVersion lastDLFileVersion, DLFileVersion latestDLFileVersion, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        String latestChecksum;
        InputStream latestInputStream;
        InputStream lastInputStream;
        block18: {
            Map latestAttributes;
            if (PropsValues.DL_FILE_ENTRY_VERSION_POLICY != 1) {
                return false;
            }
            if (majorVersion) {
                return false;
            }
            if (Validator.equals((Object)serviceContext.getCommand(), (Object)"revert")) {
                return false;
            }
            if (!Validator.equals((Object)lastDLFileVersion.getTitle(), (Object)latestDLFileVersion.getTitle())) {
                return false;
            }
            if (!Validator.equals((Object)lastDLFileVersion.getDescription(), (Object)latestDLFileVersion.getDescription())) {
                return false;
            }
            if (lastDLFileVersion.getFileEntryTypeId() != latestDLFileVersion.getFileEntryTypeId()) {
                return false;
            }
            if (serviceContext.getWorkflowAction() == 2) {
                return false;
            }
            DLFileEntryType dlFileEntryType = lastDLFileVersion.getDLFileEntryType();
            List ddmStructures = dlFileEntryType.getDDMStructures();
            for (DDMStructure ddmStructure : ddmStructures) {
                DDMFormValues latestDDMFormValues;
                DLFileEntryMetadata lastFileEntryMetadata = this.dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), lastDLFileVersion.getFileVersionId());
                if (lastFileEntryMetadata == null) {
                    return false;
                }
                DLFileEntryMetadata latestFileEntryMetadata = this.dlFileEntryMetadataLocalService.getFileEntryMetadata(ddmStructure.getStructureId(), latestDLFileVersion.getFileVersionId());
                DDMFormValues lastDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)lastFileEntryMetadata.getDDMStorageId());
                if (lastDDMFormValues.equals((Object)(latestDDMFormValues = StorageEngineManagerUtil.getDDMFormValues((long)latestFileEntryMetadata.getDDMStorageId())))) continue;
                return false;
            }
            ExpandoBridge lastExpandoBridge = lastDLFileVersion.getExpandoBridge();
            ExpandoBridge latestExpandoBridge = latestDLFileVersion.getExpandoBridge();
            Map lastAttributes = lastExpandoBridge.getAttributes();
            if (!lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes())) {
                return false;
            }
            long lastSize = lastDLFileVersion.getSize();
            long latestSize = latestDLFileVersion.getSize();
            if (lastSize == 0L && latestSize >= 0L) {
                return true;
            }
            if (lastSize != latestSize) {
                return false;
            }
            lastInputStream = null;
            latestInputStream = null;
            String lastChecksum = lastDLFileVersion.getChecksum();
            if (Validator.isNull((String)lastChecksum)) {
                lastInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)lastDLFileVersion.getVersion());
                lastChecksum = DigesterUtil.digestBase64((InputStream)lastInputStream);
                lastDLFileVersion.setChecksum(lastChecksum);
                this.dlFileVersionPersistence.update((BaseModel)lastDLFileVersion);
            }
            if (!lastChecksum.equals(latestChecksum = DigesterUtil.digestBase64((InputStream)(latestInputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)latestDLFileVersion.getVersion()))))) break block18;
            boolean bl = true;
            StreamUtil.cleanUp((Closeable[])new Closeable[]{lastInputStream});
            StreamUtil.cleanUp((Closeable[])new Closeable[]{latestInputStream});
            return bl;
        }
        try {
            latestDLFileVersion.setChecksum(latestChecksum);
            this.dlFileVersionPersistence.update((BaseModel)latestDLFileVersion);
        }
        catch (Exception e) {
            block19: {
                try {
                    if (!_log.isWarnEnabled()) break block19;
                    _log.warn((Object)e, (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{lastInputStream});
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{latestInputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{lastInputStream});
            StreamUtil.cleanUp((Closeable[])new Closeable[]{latestInputStream});
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{lastInputStream});
        StreamUtil.cleanUp((Closeable[])new Closeable[]{latestInputStream});
        return false;
    }
}

