/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.CustomUserAttributes;
import com.liferay.portal.kernel.portlet.UserAttributes;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UserInfoFactory {
    private static final Log _log = LogFactoryUtil.getLog(UserInfoFactory.class);

    public static LinkedHashMap<String, String> getUserInfo(HttpServletRequest request, Portlet portlet) {
        if (request.getRemoteUser() == null) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = PortalUtil.getUser((HttpServletRequest)request);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(long userId, Portlet portlet) {
        if (userId <= 0L) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(User user, LinkedHashMap<String, String> userInfo, Portlet portlet) {
        PortletApp portletApp = portlet.getPortletApp();
        try {
            UserAttributes userAttributes = new UserAttributes(user);
            userInfo.put("liferay.company.id", userAttributes.getValue("liferay.company.id"));
            userInfo.put("liferay.user.id", userAttributes.getValue("liferay.user.id"));
            for (String userAttributeName : portletApp.getUserAttributes()) {
                String userAttributeValue = userAttributes.getValue(userAttributeName);
                if (userAttributeValue == null) continue;
                userInfo.put(userAttributeName, userAttributeValue);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        Map unmodifiableUserInfo = Collections.unmodifiableMap((Map)userInfo.clone());
        HashMap<String, CustomUserAttributes> customUserAttributesMap = new HashMap<String, CustomUserAttributes>();
        Map customUserAttributesClassNames = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributesClassNames.entrySet()) {
            String attrValue;
            String userAttributeName = (String)entry.getKey();
            String customUserAttributesClassName = (String)entry.getValue();
            CustomUserAttributes customUserAttributes = (CustomUserAttributes)customUserAttributesMap.get(customUserAttributesClassName);
            if (customUserAttributes == null) {
                if (portletApp.isWARFile()) {
                    PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
                    Map<String, CustomUserAttributes> portletContextBagCustomUserAttributes = portletContextBag.getCustomUserAttributes();
                    customUserAttributes = portletContextBagCustomUserAttributes.get(customUserAttributesClassName);
                    if (customUserAttributes != null) {
                        customUserAttributes = (CustomUserAttributes)customUserAttributes.clone();
                    }
                } else {
                    customUserAttributes = UserInfoFactory.newInstance(customUserAttributesClassName);
                }
                if (customUserAttributes != null) {
                    customUserAttributesMap.put(customUserAttributesClassName, customUserAttributes);
                }
            }
            if (customUserAttributes == null || (attrValue = customUserAttributes.getValue(userAttributeName, unmodifiableUserInfo)) == null) continue;
            userInfo.put(userAttributeName, attrValue);
        }
        return userInfo;
    }

    private static CustomUserAttributes newInstance(String className) {
        try {
            return (CustomUserAttributes)InstanceFactory.newInstance((String)className);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

