/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerEntry;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.util.TrashUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebServerServlet
extends HttpServlet {
    public static final String PATH_PORTLET_FILE_ENTRY = "portlet_file_entry";
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, (String)ReleaseInfo.getName());
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, (String)"partial");
    private static final Log _log = LogFactoryUtil.getLog(WebServerServlet.class);
    private static final Set<String> _acceptRangesMimeTypes = SetUtil.fromArray((Object[])PropsValues.WEB_SERVER_SERVLET_ACCEPT_RANGES_MIME_TYPES);
    private final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"d MMM yyyy HH:mm z");
    private boolean _lastModified = true;
    private TemplateResource _templateResource;

    /*
     * Exception decompiling
     */
    public static boolean hasFiles(HttpServletRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._lastModified = GetterUtil.getBoolean((String)servletConfig.getInitParameter("last_modified"), (boolean)true);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String templateId = "com/liferay/portal/webserver/dependencies/template.ftl";
        URL url = classLoader.getResource(templateId);
        this._templateResource = new URLTemplateResource(templateId, url);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        User user = null;
        try {
            String path;
            String[] pathArray;
            user = WebServerServlet._getUser(request);
            PrincipalThreadLocal.setName((long)user.getUserId());
            PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            if (this._lastModified) {
                long ifModifiedSince;
                long lastModified = this.getLastModified(request);
                if (lastModified > 0L && (ifModifiedSince = request.getDateHeader("If-Modified-Since")) > 0L && ifModifiedSince == lastModified) {
                    response.setStatus(304);
                    return;
                }
                if (lastModified > 0L) {
                    response.setDateHeader("Last-Modified", lastModified);
                }
            }
            if ((pathArray = StringUtil.split((String)(path = HttpUtil.fixPath((String)request.getPathInfo())), (char)'/')).length == 0) {
                this.sendGroups(response, user, request.getServletPath() + "/" + path);
            } else if (Validator.isNumber((String)pathArray[0])) {
                this.sendFile(request, response, user, pathArray);
            } else if (PATH_PORTLET_FILE_ENTRY.equals(pathArray[0])) {
                this.sendPortletFileEntry(request, response, pathArray);
            } else {
                if (PropsValues.WEB_SERVER_SERVLET_CHECK_IMAGE_GALLERY && this.isLegacyImageGalleryImageId(request, response)) {
                    return;
                }
                Image image = this.getImage(request, true);
                if (image != null) {
                    this.writeImage(image, request, response);
                } else {
                    this.sendDocumentLibrary(request, response, user, request.getServletPath() + "/" + path, pathArray);
                }
            }
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (NoSuchFolderException nsfe) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfe), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, user, request, response);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected static FileEntry getPortletFileEntry(HttpServletRequest request, String[] pathArray) throws Exception {
        long groupId = GetterUtil.getLong((String)pathArray[1]);
        String uuid = pathArray[3];
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((String)uuid, (long)groupId);
        int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)0);
        if (status != 8 && fileEntry.isInTrash()) {
            return null;
        }
        return fileEntry;
    }

    protected Image convertFileEntry(boolean smallImage, FileEntry fileEntry) throws PortalException {
        try {
            ImageImpl image = new ImageImpl();
            image.setModifiedDate(fileEntry.getModifiedDate());
            InputStream is = null;
            is = smallImage ? ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileEntry.getFileVersion(), (int)0) : fileEntry.getContentStream();
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            image.setTextObj(bytes);
            image.setType(fileEntry.getExtension());
            return image;
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected Image getDefaultImage(HttpServletRequest request, long imageId) {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (path.startsWith("/company_logo") || path.startsWith("/layout_set_logo") || path.startsWith("/logo")) {
            return ImageToolUtil.getDefaultCompanyLogo();
        }
        if (path.startsWith("/organization_logo")) {
            return ImageToolUtil.getDefaultOrganizationLogo();
        }
        if (path.startsWith("/user_female_portrait")) {
            return ImageToolUtil.getDefaultUserFemalePortrait();
        }
        if (path.startsWith("/user_male_portrait")) {
            return ImageToolUtil.getDefaultUserMalePortrait();
        }
        if (path.startsWith("/user_portrait")) {
            return ImageToolUtil.getDefaultUserMalePortrait();
        }
        return null;
    }

    protected FileEntry getFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long fileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            FileShortcut dlFileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
            return DLAppServiceUtil.getFileEntry((long)dlFileShortcut.getToFileEntryId());
        }
        if (pathArray.length == 2) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            return DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)groupId);
        }
        if (pathArray.length == 3) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            long folderId = GetterUtil.getLong((String)pathArray[1]);
            String fileName = HttpUtil.decodeURL((String)pathArray[2]);
            if (fileName.contains("?")) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            return DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        long groupId = GetterUtil.getLong((String)pathArray[0]);
        String uuid = pathArray[3];
        return DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    protected Image getImage(HttpServletRequest request, boolean getDefault) throws PortalException {
        Image image = null;
        long imageId = this.getImageId(request);
        if (imageId > 0L) {
            image = ImageServiceUtil.getImage((long)imageId);
            String path = GetterUtil.getString((String)request.getPathInfo());
            if (path.startsWith("/user_female_portrait") || path.startsWith("/user_male_portrait") || path.startsWith("/user_portrait")) {
                image = this.getUserPortraitImageResized(image, imageId);
            }
        } else {
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean igSmallImage = ParamUtil.getBoolean((HttpServletRequest)request, (String)"igSmallImage");
            if (Validator.isNotNull((String)uuid) && groupId > 0L) {
                try {
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    image = this.convertFileEntry(igSmallImage, fileEntry);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (getDefault && image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Get a default image for " + imageId));
            }
            image = this.getDefaultImage(request, imageId);
        }
        return image;
    }

    protected byte[] getImageBytes(HttpServletRequest request, Image image) throws PortalException {
        byte[] textObj = image.getTextObj();
        if (textObj == null || textObj.length == 0) {
            throw new NoSuchFileException();
        }
        try {
            if (!PropsValues.IMAGE_AUTO_SCALE) {
                return textObj;
            }
            ImageBag imageBag = null;
            if (image.getImageId() == 0L) {
                imageBag = ImageToolUtil.read((byte[])textObj);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                image.setHeight(renderedImage.getHeight());
                image.setWidth(renderedImage.getWidth());
            }
            int height = ParamUtil.getInteger((HttpServletRequest)request, (String)"height", (int)image.getHeight());
            int width = ParamUtil.getInteger((HttpServletRequest)request, (String)"width", (int)image.getWidth());
            if (height >= image.getHeight() && width >= image.getWidth()) {
                return textObj;
            }
            if (image.getImageId() != 0L) {
                imageBag = ImageToolUtil.read((byte[])textObj);
            }
            RenderedImage renderedImage = ImageToolUtil.scale((RenderedImage)imageBag.getRenderedImage(), (int)height, (int)width);
            return ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error scaling image " + image.getImageId()), (Throwable)e);
            }
            return textObj;
        }
    }

    protected long getImageId(HttpServletRequest request) {
        long imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"image_id");
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"img_id");
        }
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"i_id");
        }
        User user = null;
        if (imageId <= 0L) {
            long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
            String screenName = ParamUtil.getString((HttpServletRequest)request, (String)"screenName");
            if (companyId > 0L && Validator.isNotNull((String)screenName) && (user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName)) != null) {
                imageId = user.getPortraitId();
            }
        }
        if (PropsValues.USERS_IMAGE_CHECK_TOKEN && imageId > 0L) {
            String imageIdToken = ParamUtil.getString((HttpServletRequest)request, (String)"img_id_token");
            if (user == null) {
                user = UserLocalServiceUtil.fetchUserByPortraitId((long)imageId);
            }
            if (user != null && !imageIdToken.equals(DigesterUtil.digest((String)user.getUserUuid()))) {
                return 0L;
            }
        }
        return imageId;
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            Date modifiedDate = null;
            Image image = this.getImage(request, true);
            if (image != null) {
                modifiedDate = image.getModifiedDate();
            } else {
                String path = HttpUtil.fixPath((String)request.getPathInfo());
                String[] pathArray = StringUtil.split((String)path, (char)'/');
                if (pathArray.length == 0) {
                    return -1L;
                }
                if (pathArray[0].equals("language")) {
                    return -1L;
                }
                FileEntry fileEntry = null;
                try {
                    fileEntry = this.getFileEntry(pathArray);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (fileEntry == null) {
                    return -1L;
                }
                String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
                if (Validator.isNotNull((String)version)) {
                    FileVersion fileVersion = fileEntry.getFileVersion(version);
                    modifiedDate = fileVersion.getModifiedDate();
                } else {
                    modifiedDate = fileEntry.getModifiedDate();
                }
            }
            if (modifiedDate == null) {
                modifiedDate = PortalUtil.getUptime();
            }
            return modifiedDate.getTime() / 1000L * 1000L;
        }
        catch (PrincipalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return -1L;
    }

    protected Image getUserPortraitImageResized(Image image, long imageId) throws PortalException {
        if (image == null) {
            return null;
        }
        if (PropsValues.USERS_IMAGE_MAX_HEIGHT > 0 && image.getHeight() > PropsValues.USERS_IMAGE_MAX_HEIGHT || PropsValues.USERS_IMAGE_MAX_WIDTH > 0 && image.getWidth() > PropsValues.USERS_IMAGE_MAX_WIDTH) {
            User user = UserLocalServiceUtil.getUserByPortraitId((long)imageId);
            UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])image.getTextObj());
            return ImageLocalServiceUtil.getImage((long)imageId);
        }
        return image;
    }

    protected boolean isLegacyImageGalleryImageId(HttpServletRequest request, HttpServletResponse response) {
        try {
            long imageId = this.getImageId(request);
            if (imageId == 0L) {
                return false;
            }
            Repository repository = RepositoryProviderUtil.getImageRepository((long)imageId);
            if (!repository.isCapabilityProvided(ThumbnailCapability.class)) {
                return false;
            }
            ThumbnailCapability thumbnailCapability = (ThumbnailCapability)repository.getCapability(ThumbnailCapability.class);
            FileEntry fileEntry = thumbnailCapability.fetchImageFileEntry(imageId);
            if (fileEntry == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String queryString = "";
            if (imageId == thumbnailCapability.getSmallImageId(fileEntry)) {
                queryString = "&imageThumbnail=1";
            } else if (imageId == thumbnailCapability.getCustom1ImageId(fileEntry)) {
                queryString = "&imageThumbnail=2";
            } else if (imageId == thumbnailCapability.getCustom2ImageId(fileEntry)) {
                queryString = "&imageThumbnail=3";
            }
            FileVersion fileVersion = fileEntry.getFileVersion();
            if (PropsValues.DL_FILE_ENTRY_IG_THUMBNAIL_GENERATION && Validator.isNotNull((String)queryString)) {
                ImageProcessorUtil.hasImages((FileVersion)fileVersion);
            }
            String url = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileVersion, (ThemeDisplay)themeDisplay, (String)queryString);
            response.setHeader("Location", url);
            response.setStatus(301);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isSupportsRangeHeader(String contentType) {
        return _acceptRangesMimeTypes.contains(contentType);
    }

    protected void processPrincipalException(Throwable t, User user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!user.isDefaultUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)t), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String redirect = PortalUtil.getPathMain() + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        response.sendRedirect(redirect);
    }

    protected void sendDocumentLibrary(HttpServletRequest request, HttpServletResponse response, User user, String path, String[] pathArray) throws Exception {
        long groupId = WebServerServlet._getGroupId(user.getCompanyId(), pathArray[0]);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        boolean directoryIndexingEnabled = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("directoryIndexingEnabled"), (boolean)PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED);
        if (!directoryIndexingEnabled) {
            throw new NoSuchFolderException();
        }
        long folderId = 0L;
        for (int i = 1; i < pathArray.length; ++i) {
            String name = pathArray[i];
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
                folderId = folder.getFolderId();
                continue;
            }
            catch (NoSuchFolderException nsfe) {
                if (i != pathArray.length - 1) {
                    throw nsfe;
                }
                String title = name;
                this.sendFile(response, user, groupId, folderId, title);
                return;
            }
        }
        try {
            this.sendFile(response, user, groupId, folderId, "index.html");
            return;
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                try {
                    this.sendFile(response, user, groupId, folderId, "index.htm");
                    return;
                }
                catch (NoSuchFileEntryException nsfee) {
                }
                catch (PrincipalException pe) {}
            } else {
                throw e;
            }
            ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
            webServerEntries.add(new WebServerEntry(path, "../"));
            List folders = DLAppServiceUtil.getFolders((long)groupId, (long)folderId);
            for (Folder folder : folders) {
                WebServerEntry webServerEntry = new WebServerEntry(path, folder.getName() + "/", folder.getCreateDate(), folder.getModifiedDate(), folder.getDescription(), 0L);
                webServerEntries.add(webServerEntry);
            }
            List fileEntries = DLAppServiceUtil.getFileEntries((long)groupId, (long)folderId);
            for (FileEntry fileEntry : fileEntries) {
                WebServerEntry webServerEntry = new WebServerEntry(path, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getDescription(), fileEntry.getSize());
                webServerEntries.add(webServerEntry);
            }
            this.sendHTML(response, path, webServerEntries);
            return;
        }
    }

    protected void sendFile(HttpServletRequest request, HttpServletResponse response, User user, String[] pathArray) throws Exception {
        FileEntry fileEntry = this.getFileEntry(pathArray);
        if (fileEntry == null) {
            throw new NoSuchFileEntryException();
        }
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        if (Validator.isNull((String)version) && Validator.isNotNull((String)fileEntry.getVersion())) {
            version = fileEntry.getVersion();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version);
        if (fileEntry.isInTrash()) {
            int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)0);
            if (status != 8) {
                throw new NoSuchFileEntryException();
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            String portletId = PortletProviderUtil.getPortletId((String)TrashEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            if (!PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)portletId)) {
                throw new PrincipalException.MustHavePermission(permissionChecker, FileEntry.class.getName(), fileEntry.getFileEntryId(), new String[]{"ACCESS_IN_CONTROL_PANEL"});
            }
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        if (ParamUtil.getInteger((HttpServletRequest)request, (String)"height") > 0 || ParamUtil.getInteger((HttpServletRequest)request, (String)"width") > 0) {
            InputStream inputStream = fileVersion.getContentStream(true);
            Image image = ImageToolUtil.getImage((InputStream)inputStream);
            this.writeImage(image, request, response);
            return;
        }
        String fileName = fileVersion.getFileName();
        boolean converted = false;
        String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
        int imageThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"imageThumbnail");
        int documentThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"documentThumbnail");
        int previewFileIndex = ParamUtil.getInteger((HttpServletRequest)request, (String)"previewFileIndex");
        boolean audioPreview = ParamUtil.getBoolean((HttpServletRequest)request, (String)"audioPreview");
        boolean imagePreview = ParamUtil.getBoolean((HttpServletRequest)request, (String)"imagePreview");
        boolean videoPreview = ParamUtil.getBoolean((HttpServletRequest)request, (String)"videoPreview");
        int videoThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"videoThumbnail");
        InputStream inputStream = null;
        long contentLength = 0L;
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(ImageProcessorUtil.getThumbnailType((FileVersion)fileVersion));
            int thumbnailIndex = imageThumbnail - 1;
            inputStream = ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = ImageProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (documentThumbnail > 0 && documentThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            int thumbnailIndex = documentThumbnail - 1;
            inputStream = PDFProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = PDFProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (previewFileIndex > 0) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            inputStream = PDFProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (int)previewFileIndex);
            contentLength = PDFProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (int)previewFileIndex);
            converted = true;
        } else if (audioPreview || videoPreview) {
            String type = ParamUtil.getString((HttpServletRequest)request, (String)"type");
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(type);
            if (audioPreview) {
                inputStream = AudioProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (String)type);
                contentLength = AudioProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)type);
            } else {
                inputStream = VideoProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (String)type);
                contentLength = VideoProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)type);
            }
            converted = true;
        } else if (imagePreview) {
            String type = ImageProcessorUtil.getPreviewType((FileVersion)fileVersion);
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(type);
            inputStream = ImageProcessorUtil.getPreviewAsStream((FileVersion)fileVersion);
            contentLength = ImageProcessorUtil.getPreviewFileSize((FileVersion)fileVersion);
            converted = true;
        } else if (videoThumbnail > 0 && videoThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("jpg");
            int thumbnailIndex = videoThumbnail - 1;
            inputStream = VideoProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = VideoProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else {
            File convertedFile;
            inputStream = fileVersion.getContentStream(true);
            contentLength = fileVersion.getSize();
            if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert(tempFileId, inputStream, fileVersion.getExtension(), targetExtension)) != null) {
                fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
                inputStream = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                converted = true;
            }
        }
        FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)inputStream);
        if (flashMagicBytesUtilResult.isFlash()) {
            fileName = FileUtil.stripExtension((String)fileName) + ".swf";
        }
        inputStream = flashMagicBytesUtilResult.getInputStream();
        String contentType = null;
        contentType = converted ? MimeTypesUtil.getContentType((String)fileName) : fileVersion.getMimeType();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Content type set to " + contentType));
        }
        if (this.isSupportsRangeHeader(contentType)) {
            ServletResponseUtil.sendFileWithRangeHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType);
        } else {
            boolean download = ParamUtil.getBoolean((HttpServletRequest)request, (String)"download");
            if (download) {
                ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType, (String)"attachment");
            } else {
                ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType);
            }
        }
    }

    protected void sendFile(HttpServletResponse response, User user, long groupId, long folderId, String title) throws Exception {
        FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
        String contentType = fileEntry.getMimeType();
        response.setContentType(contentType);
        InputStream inputStream = fileEntry.getContentStream();
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)inputStream, (long)fileEntry.getSize());
    }

    protected void sendGroups(HttpServletResponse response, User user, String path) throws Exception {
        if (!PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED) {
            response.setStatus(403);
            throw new PrincipalException();
        }
        ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
        List groups = WebDAVUtil.getGroups((User)user);
        for (Group group : groups) {
            String name = HttpUtil.fixPath((String)group.getFriendlyURL());
            WebServerEntry webServerEntry = new WebServerEntry(path, name + "/", null, null, group.getDescription(), 0L);
            webServerEntries.add(webServerEntry);
        }
        this.sendHTML(response, path, webServerEntries);
    }

    protected void sendHTML(HttpServletResponse response, String path, List<WebServerEntry> webServerEntries) throws Exception {
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)this._templateResource, (boolean)true);
        template.put((Object)"dateFormat", (Object)this._dateFormat);
        template.put((Object)"entries", webServerEntries);
        template.put((Object)"path", (Object)HttpUtil.encodePath((String)path));
        if (!_WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT) {
            if (_WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL) {
                template.put((Object)"releaseInfo", (Object)ReleaseInfo.getName());
            } else {
                template.put((Object)"releaseInfo", (Object)ReleaseInfo.getReleaseInfo());
            }
        }
        template.put((Object)"validator", (Object)Validator_IW.getInstance());
        response.setContentType("text/html; charset=UTF-8");
        template.processTemplate((Writer)response.getWriter());
    }

    protected void sendPortletFileEntry(HttpServletRequest request, HttpServletResponse response, String[] pathArray) throws Exception {
        boolean download;
        FileEntry fileEntry = WebServerServlet.getPortletFileEntry(request, pathArray);
        if (fileEntry == null) {
            return;
        }
        String fileName = HttpUtil.decodeURL((String)HtmlUtil.escape((String)pathArray[2]));
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle((String)fileName);
        }
        if (download = ParamUtil.getBoolean((HttpServletRequest)request, (String)"download")) {
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)fileEntry.getContentStream(), (long)fileEntry.getSize(), (String)fileEntry.getMimeType(), (String)"attachment");
        } else {
            InputStream is = fileEntry.getContentStream();
            FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)is);
            is = flashMagicBytesUtilResult.getInputStream();
            if (flashMagicBytesUtilResult.isFlash()) {
                fileName = FileUtil.stripExtension((String)fileName) + ".swf";
            }
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)fileEntry.getSize(), (String)fileEntry.getMimeType());
        }
    }

    protected void writeImage(Image image, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        block6: {
            if (image == null) {
                return;
            }
            String contentType = null;
            String type = image.getType();
            if (!type.equals("na")) {
                contentType = MimeTypesUtil.getExtensionContentType((String)type);
                response.setContentType(contentType);
            }
            String fileName = ParamUtil.getString((HttpServletRequest)request, (String)"fileName");
            byte[] bytes = this.getImageBytes(request, image);
            try {
                if (Validator.isNotNull((String)fileName)) {
                    ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)contentType);
                } else {
                    ServletResponseUtil.write((HttpServletResponse)response, (byte[])bytes);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    private static void _checkFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long fileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            FileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
            DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
        } else if (pathArray.length != 2) {
            if (pathArray.length == 3) {
                long groupId = GetterUtil.getLong((String)pathArray[0]);
                long folderId = GetterUtil.getLong((String)pathArray[1]);
                String fileName = HttpUtil.decodeURL((String)pathArray[2]);
                try {
                    DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
                }
                catch (RepositoryException re) {}
            } else {
                long groupId = GetterUtil.getLong((String)pathArray[0]);
                String uuid = pathArray[3];
                try {
                    DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (RepositoryException re) {
                    // empty catch block
                }
            }
        }
    }

    private static long _getGroupId(long companyId, String name) throws Exception {
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)companyId, (String)("/" + name));
        if (group != null) {
            return group.getGroupId();
        }
        User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)name);
        group = user.getGroup();
        return group.getGroupId();
    }

    private static User _getUser(HttpServletRequest request) throws Exception {
        User user;
        HttpSession session = request.getSession();
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)session);
        }
        if ((user = PortalUtil.getUser((HttpServletRequest)request)) != null) {
            return user;
        }
        String userIdString = (String)session.getAttribute("j_username");
        String password = (String)session.getAttribute("j_password");
        if (userIdString != null && password != null) {
            long userId = GetterUtil.getLong((String)userIdString);
            user = UserLocalServiceUtil.getUser((long)userId);
        } else {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            user = company.getDefaultUser();
        }
        return user;
    }
}

