/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyWorkflow
extends VerifyProcess {
    private static final String[][] _ORPHANED_ATTACHED_MODELS = new String[][]{{"KaleoInstance", "com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess", "DDLRecord", "recordId"}, {"KaleoInstanceToken", "com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess", "DDLRecord", "recordId"}, {"WorkflowDefinitionLink", "com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess", "DDLRecord", "recordId"}, {"WorkflowDefinitionLink", "com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess", "KaleoProcess", "kaleoProcessId"}};

    protected void deleteOrphaned() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (String[] orphanedAttachedModel : this.getOrphanedAttachedModels()) {
                String tableName = orphanedAttachedModel[0];
                if (!this.hasTable(tableName) || !this.hasColumn(tableName, "classNameId")) continue;
                try (PreparedStatement ps = this.connection.prepareStatement("select distinct classNameId from " + tableName);
                     ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String orphanedClassName;
                        String classNameValue;
                        long classNameId = rs.getLong("classNameId");
                        ClassName className = ClassNameLocalServiceUtil.fetchClassName((long)classNameId);
                        if (className == null || !(classNameValue = className.getValue()).equals(orphanedClassName = orphanedAttachedModel[1])) continue;
                        String orphanedTableName = orphanedAttachedModel[2];
                        String orphanedColumnName = orphanedAttachedModel[3];
                        if (!this.hasTable(orphanedTableName)) continue;
                        this.deleteOrphaned(tableName, orphanedTableName, orphanedColumnName);
                    }
                }
            }
        }
    }

    protected void deleteOrphaned(String tableName, String orphanedTableName, String orphanedColumnName) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("delete from ");
        sb.append(tableName);
        sb.append(" where classPK not in (select ");
        sb.append(orphanedColumnName);
        sb.append(" from ");
        sb.append(orphanedTableName);
        sb.append(")");
        this.runSQL(sb.toString());
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteOrphaned();
    }

    protected String[][] getOrphanedAttachedModels() {
        return _ORPHANED_ATTACHED_MODELS;
    }
}

