/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.journal.kernel.util.JournalConverterManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import com.liferay.portal.upgrade.v6_2_0.util.JournalFeedTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradeJournal
extends BaseUpgradePortletPreferences {
    private static final int _DDM_STRUCTURE_TYPE_DEFAULT = 0;
    private static final String _DDM_TEMPLATE_MODE_CREATE = "create";
    private static final String _DDM_TEMPLATE_TYPE_DISPLAY = "display";
    private static final String _PORTLET_ID_ASSET_PUBLISHER = "101";
    private static final String _PORTLET_ID_JOURNAL_CONTENT = "56";
    private static final String _PORTLET_ID_JOURNAL_CONTENT_LIST = "62";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);
    private final Map<String, Long> _ddmStructureIds = new HashMap<String, Long>();
    private final Map<Long, Long> _ddmStructurePKs = new HashMap<Long, Long>();

    protected void addDDMStructure(String uuid_, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long parentDDMStructureId, long classNameId, String ddmStructureKey, String name, String description, String xsd, String storageType, int type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DDMStructure (uuid_, structureId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate, ");
        sb.append("parentStructureId, classNameId, structureKey, name, ");
        sb.append("description, xsd, storageType, type_) values (?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, uuid_);
            ps.setLong(2, ddmStructureId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, parentDDMStructureId);
            ps.setLong(10, classNameId);
            ps.setString(11, ddmStructureKey);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setString(14, JournalConverterManagerUtil.getDDMXSD((String)xsd, (Locale)this.getDefaultLocale(companyId)));
            ps.setString(15, storageType);
            ps.setInt(16, type);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to upgrade dynamic data mapping structure with UUID " + uuid_));
            throw e;
        }
    }

    protected void addDDMStructure(String uuid_, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, String parentStructureId, String ddmStructureKey, String name, String description, String xsd) throws Exception {
        long insertedDDMStructureId;
        long parentDDMStructureId = 0L;
        if (Validator.isNotNull((String)parentStructureId)) {
            parentDDMStructureId = this.updateStructure(parentStructureId);
        }
        if ((insertedDDMStructureId = this.getDDMStructureId(groupId, ddmStructureKey, false)) == 0L) {
            this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentDDMStructureId, PortalUtil.getClassNameId((String)"com.liferay.portlet.journal.model.JournalArticle"), ddmStructureKey, name, description, xsd, "xml", 0);
        }
    }

    protected void addDDMTemplate(String uuid_, long ddmTemplateId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String templateKey, String name, String description, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, long smallImageId, String smallImageURL) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("insert into DDMTemplate (uuid_, templateId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate,");
        sb.append("classNameId, classPK , templateKey, name, description,");
        sb.append("type_, mode_, language, script, cacheable, smallImage,");
        sb.append("smallImageId, smallImageURL) values (?, ?, ?, ?, ?, ?,");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, uuid_);
            ps.setLong(2, ddmTemplateId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, classNameId);
            ps.setLong(10, classPK);
            ps.setString(11, templateKey);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setString(14, type);
            ps.setString(15, mode);
            ps.setString(16, language);
            ps.setString(17, script);
            ps.setBoolean(18, cacheable);
            ps.setBoolean(19, smallImage);
            ps.setLong(20, smallImageId);
            ps.setString(21, smallImageURL);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to upgrade dynamic data mapping template with UUID " + uuid_));
            throw e;
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(JournalFeedTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnName((UpgradeProcess)this, "feedType", "feedFormat VARCHAR(75) null")});
        this.updateStructures();
        this.updateTemplates();
        this.updateAssetEntryClassTypeId();
        super.doUpgrade();
    }

    /*
     * Exception decompiling
     */
    protected long getCompanyGroupId(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getDDMStructureClassNameId() {
        return PortalUtil.getClassNameId((String)"com.liferay.portlet.dynamicdatamapping.DDMStructure");
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId) {
        return this.getDDMStructureId(groupId, companyGroupId, structureId, true);
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId, boolean warn) {
        if (Validator.isNull((String)structureId)) {
            return 0L;
        }
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId == null && companyGroupId != 0L) {
            ddmStructureId = this._ddmStructureIds.get(companyGroupId + "#" + structureId);
        }
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        if (warn && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler();
            sb.append("Unable to get the DDM structure ID for group ");
            sb.append(groupId);
            if (companyGroupId != 0L) {
                sb.append(" or global group");
            }
            sb.append(" and journal structure ID ");
            sb.append(structureId);
            _log.warn((Object)sb.toString());
        }
        return 0L;
    }

    protected long getDDMStructureId(long groupId, String structureId, boolean warn) {
        return this.getDDMStructureId(groupId, 0L, structureId, warn);
    }

    protected Locale getDefaultLocale(long companyId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select languageId from User_ where companyId = ? and defaultUser = ?");){
            ps.setLong(1, companyId);
            ps.setBoolean(2, true);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String languageId = rs.getString("languageId");
                    Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                    return locale;
                }
            }
        }
        return LocaleUtil.getSiteDefault();
    }

    protected String[] getPortletIds() {
        return new String[]{"56_INSTANCE_%", "62_INSTANCE_%", "101_INSTANCE_%"};
    }

    protected void updateAssetEntryClassTypeId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select companyId, groupId, resourcePrimKey, structureId from JournalArticle where structureId != ''");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "update AssetEntry set classTypeId = ? where classPK = ?");){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                String structureId = rs.getString("structureId");
                long ddmStructureId = this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId);
                ps2.setLong(1, ddmStructureId);
                ps2.setLong(2, resourcePrimKey);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updatePreferencesClassPKs(PortletPreferences preferences, String key) throws Exception {
        String[] oldValues = preferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] oldPrimaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String oldPrimaryKey : oldPrimaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)oldPrimaryKey)) break;
                Long newPrimaryKey = this._ddmStructurePKs.get(GetterUtil.getLong((String)oldPrimaryKey));
                if (!Validator.isNotNull((Long)newPrimaryKey)) continue;
                newValue = StringUtil.replace((String)newValue, (String)oldPrimaryKey, (String)String.valueOf(newPrimaryKey));
            }
            newValues[i] = newValue;
        }
        preferences.setValues(key, newValues);
    }

    protected void updateResourcePermission(long companyId, String oldClassName, String newClassName, long oldPrimKey, long newPrimKey) throws Exception {
        StringBundler sb = new StringBundler(11);
        sb.append("update ResourcePermission set name = '");
        sb.append(newClassName);
        sb.append("', primKey = '");
        sb.append(newPrimKey);
        sb.append("' where companyId = ");
        sb.append(companyId);
        sb.append(" and name = '");
        sb.append(oldClassName);
        sb.append("' and primKey = '");
        sb.append(oldPrimKey);
        sb.append("'");
        this.runSQL(sb.toString());
    }

    protected long updateStructure(ResultSet rs) throws Exception {
        String uuid_ = rs.getString("uuid_");
        long id_ = rs.getLong("id_");
        long groupId = rs.getLong("groupId");
        long companyId = rs.getLong("companyId");
        long userId = rs.getLong("userId");
        String userName = rs.getString("userName");
        Timestamp createDate = rs.getTimestamp("createDate");
        Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
        String structureId = rs.getString("structureId");
        String parentStructureId = rs.getString("parentStructureId");
        String name = rs.getString("name");
        String description = rs.getString("description");
        String xsd = rs.getString("xsd");
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        ddmStructureId = this.increment();
        this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentStructureId, structureId, name, description, xsd);
        this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalStructure", "com.liferay.portlet.dynamicdatamapping.DDMStructure", id_, ddmStructureId);
        this._ddmStructureIds.put(groupId + "#" + structureId, ddmStructureId);
        this._ddmStructurePKs.put(id_, ddmStructureId);
        return ddmStructureId;
    }

    /*
     * Exception decompiling
     */
    protected long updateStructure(String structureId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from JournalStructure");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                this.updateStructure(rs);
            }
            this.runSQL("drop table JournalStructure");
        }
    }

    protected void updateTemplates() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from JournalTemplate");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long id_ = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String templateId = rs.getString("templateId");
                String structureId = rs.getString("structureId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String language = rs.getString("langType");
                String script = rs.getString("xsl");
                boolean cacheable = rs.getBoolean("cacheable");
                boolean smallImage = rs.getBoolean("smallImage");
                long smallImageId = rs.getLong("smallImageId");
                String smallImageURL = rs.getString("smallImageURL");
                long ddmTemplateId = this.increment();
                long classNameId = this.getDDMStructureClassNameId();
                long classPK = this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId);
                this.addDDMTemplate(uuid_, ddmTemplateId, groupId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, templateId, name, description, _DDM_TEMPLATE_TYPE_DISPLAY, _DDM_TEMPLATE_MODE_CREATE, language, script, cacheable, smallImage, smallImageId, smallImageURL);
                this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalTemplate", "com.liferay.portlet.dynamicdatamapping.DDMTemplate", id_, ddmTemplateId);
            }
            this.runSQL("drop table JournalTemplate");
        }
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String structureId;
        PortletPreferences preferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        if (portletId.startsWith(_PORTLET_ID_ASSET_PUBLISHER)) {
            this.updatePreferencesClassPKs(preferences, "anyClassTypeJournalArticleAssetRendererFactory");
            this.updatePreferencesClassPKs(preferences, "classTypeIds");
            this.updatePreferencesClassPKs(preferences, "classTypeIdsJournalArticleAssetRendererFactory");
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT)) {
            String templateId = preferences.getValue("templateId", "");
            if (Validator.isNotNull((String)templateId)) {
                preferences.reset("templateId");
                preferences.setValue("ddmTemplateKey", templateId);
            }
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT_LIST) && Validator.isNotNull((String)(structureId = preferences.getValue("structureId", "")))) {
            preferences.reset("structureId");
            preferences.setValue("ddmStructureKey", structureId);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)preferences);
    }
}

