/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.social.kernel.util.SocialCounterPeriodUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UpgradeSocial
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeSocial.class);
    private final Map<String, Tuple> _equityToActivityMap = new HashMap<String, Tuple>();

    public UpgradeSocial() {
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "ADD_ENTRY", 2);
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "ADD_VOTE", 10004);
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "SUBSCRIBE", 10002);
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "UPDATE", 3);
        this.putEquityToActivityMap("com.liferay.portlet.blogs.model.BlogsEntry", "VIEW", 10001);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBCategory", "SUBSCRIBE", 10002);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBMessage", "ADD_MESSAGE", 1);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBMessage", "ADD_VOTE", 10004);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBMessage", "REPLY_TO_MESSAGE", 2);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBMessage", "VIEW", 10001);
        this.putEquityToActivityMap("com.liferay.portlet.messageboards.model.MBThread", "SUBSCRIBE", "com.liferay.portlet.messageboards.model.MBMessage", 10002);
        this.putEquityToActivityMap("com.liferay.portlet.journal.model.JournalArticle", "ADD_ARTICLE", 1);
        this.putEquityToActivityMap("com.liferay.portlet.journal.model.JournalArticle", "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap("com.liferay.portlet.journal.model.JournalArticle", "UPDATE", 2);
        this.putEquityToActivityMap("com.liferay.portlet.journal.model.JournalArticle", "VIEW", 10001);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiNode", "SUBSCRIBE", 10002);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "ADD_ATTACHMENT", 10006);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "ADD_PAGE", 1);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "SUBSCRIBE", 10002);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "UPDATE", 2);
        this.putEquityToActivityMap("com.liferay.portlet.wiki.model.WikiPage", "VIEW", 10001);
    }

    protected void addActivityCounter(long activityCounterId, long groupId, long companyId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int graceValue, int startPeriod, int endPeriod) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into SocialActivityCounter (activityCounterId, ");
        sb.append("groupId, companyId, classNameId, classPK, name, ");
        sb.append("ownerType, currentValue, totalValue, graceValue, ");
        sb.append("startPeriod, endPeriod) values (?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, activityCounterId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, classNameId);
            ps.setLong(5, classPK);
            ps.setString(6, name);
            ps.setInt(7, ownerType);
            ps.setInt(8, currentValue);
            ps.setInt(9, totalValue);
            ps.setInt(10, graceValue);
            ps.setInt(11, startPeriod);
            ps.setInt(12, endPeriod);
            ps.executeUpdate();
        }
    }

    protected void addActivitySetting(long groupId, long companyId, long classNameId, int activityType, String name, int ownerType, int limitValue, int value) throws Exception {
        JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject();
        valueJSONObject.put("enabled", true);
        valueJSONObject.put("limitPeriod", 1);
        valueJSONObject.put("limitValue", limitValue);
        valueJSONObject.put("ownerType", ownerType);
        valueJSONObject.put("value", value);
        this.addActivitySetting(this.increment(), groupId, companyId, classNameId, activityType, name, valueJSONObject.toString());
    }

    protected void addActivitySetting(long activitySettingId, long groupId, long companyId, long classNameId, int activityType, String name, String value) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into SocialActivitySetting (activitySettingId, groupId, companyId, classNameId, activityType, name, value) values (?, ?, ?, ?, ?, ?, ?)");){
            ps.setLong(1, activitySettingId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, classNameId);
            ps.setInt(5, activityType);
            ps.setString(6, name);
            ps.setString(7, value);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        this.migrateEquityGroupSettings();
        this.migrateEquitySettings();
        this.migrateEquityLogs();
        this.dropEquityTables();
    }

    protected void dropEquityTables() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("drop table SocialEquityAssetEntry");
            this.runSQL("drop table SocialEquityGroupSetting");
            this.runSQL("drop table SocialEquityHistory");
            this.runSQL("drop table SocialEquityLog");
            this.runSQL("drop table SocialEquitySetting");
            this.runSQL("drop table SocialEquityUser");
        }
    }

    protected String encodeEquityToActivityKey(long classNameId, String actionId) {
        StringBundler sb = new StringBundler(3);
        sb.append(classNameId);
        sb.append("#");
        sb.append(actionId);
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    protected Object[] getActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod, int endPeriod) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long[] getAssetEntryArray(long assetEntryId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long[] getAssetEntryArray(String className, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long getMBThreadRootMessageId(long mbThreadId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected int getTotalValue(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void migrateEquityGroupSettings() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            try (PreparedStatement ps = this.connection.prepareStatement("select groupId, companyId, classNameId, enabled from SocialEquityGroupSetting where type_ = 1");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    long classNameId = rs.getLong("classNameId");
                    boolean enabled = rs.getBoolean("enabled");
                    this.addActivitySetting(this.increment(), groupId, companyId, classNameId, 0, "enabled", String.valueOf(enabled));
                }
            }
            StringBundler sb = new StringBundler(7);
            sb.append("select groupId from SocialActivitySetting where ");
            sb.append("activityType = 0 and name = 'enabled' and ");
            sb.append("value = 'true' and classNameId in (");
            long mbMessageClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.messageboards.model.MBMessage");
            sb.append(mbMessageClassNameId);
            sb.append(", ");
            long mbThreadClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.messageboards.model.MBThread");
            sb.append(mbThreadClassNameId);
            sb.append(")");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    sb = new StringBundler(6);
                    sb.append("update SocialActivitySetting set value = 'true' ");
                    sb.append("where groupId = ");
                    sb.append(groupId);
                    sb.append(" and activityType = 0 and value = 'enabled' and ");
                    sb.append("classNameId = ");
                    sb.append(mbThreadClassNameId);
                    this.runSQL(sb.toString());
                }
                this.runSQL("delete from SocialActivitySetting where classNameId = " + mbThreadClassNameId);
            }
        }
    }

    protected void migrateEquityLog(ResultSet rs) throws Exception {
        long classNameId;
        String className;
        long assetEntryId = rs.getLong("assetEntryId");
        long[] assetEntryArray = this.getAssetEntryArray(assetEntryId);
        if (assetEntryArray == null) {
            return;
        }
        String actionId = rs.getString("actionId");
        if (actionId.equals("SUBSCRIBE") && (className = PortalUtil.getClassName((long)(classNameId = assetEntryArray[3]))).equals("com.liferay.portlet.messageboards.model.MBThread")) {
            long classPK = assetEntryArray[4];
            long mbThreadRootMessageId = this.getMBThreadRootMessageId(classPK);
            if (mbThreadRootMessageId == -1L) {
                return;
            }
            assetEntryArray = this.getAssetEntryArray("com.liferay.portlet.messageboards.model.MBMessage", mbThreadRootMessageId);
            if (assetEntryArray == null) {
                return;
            }
        }
        classNameId = PortalUtil.getClassNameId((String)"com.liferay.portal.model.User");
        long classPK = rs.getLong("userId");
        String name = "participation";
        int ownerType = 1;
        int actionDate = rs.getInt("actionDate");
        Date actionDateDate = SocialCounterPeriodUtil.getDate((int)(actionDate - 365));
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((long)actionDateDate.getTime());
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((long)actionDateDate.getTime());
        if (endPeriod == SocialCounterPeriodUtil.getEndPeriod()) {
            endPeriod = -1;
        }
        int type = rs.getInt("type_");
        int value = rs.getInt("value");
        long groupId = assetEntryArray[0];
        long companyId = assetEntryArray[1];
        if (type == 1) {
            long userId = assetEntryArray[2];
            name = "contribution";
            ownerType = 3;
            this.updateActivityCounter(this.increment(), groupId, companyId, classNameId, userId, name, ownerType, startPeriod, endPeriod, value);
            classNameId = assetEntryArray[3];
            classPK = assetEntryArray[4];
            name = "popularity";
            ownerType = 2;
        }
        long equityLogId = rs.getLong("equityLogId");
        this.updateActivityCounter(equityLogId, groupId, companyId, classNameId, classPK, name, ownerType, startPeriod, endPeriod, value);
    }

    protected void migrateEquityLogs() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            Throwable throwable;
            ResultSet rs;
            StringBundler sb = new StringBundler(4);
            sb.append("select AssetEntry.classNameId, AssetEntry.classPK, ");
            sb.append("SocialEquityLog.* from SocialEquityLog, AssetEntry ");
            sb.append("where SocialEquityLog.assetEntryId = ");
            sb.append("AssetEntry.entryId order by actionDate");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        this.migrateEquityLog(rs);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            sb = new StringBundler(4);
            sb.append("select groupId, classNameId, classPK, name, ");
            sb.append("max(startPeriod) as startPeriod ");
            sb.append("from SocialActivityCounter group by groupId, ");
            sb.append("classNameId, classPK, name");
            ps = this.connection.prepareStatement(sb.toString());
            var5_7 = null;
            try {
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        long groupId = rs.getLong("groupId");
                        long classNameId = rs.getLong("classNameId");
                        long classPK = rs.getLong("classPK");
                        String name = rs.getString("name");
                        int startPeriod = rs.getInt("startPeriod");
                        sb = new StringBundler(12);
                        sb.append("update SocialActivityCounter set endPeriod = ");
                        sb.append(-1);
                        sb.append(" where groupId = ");
                        sb.append(groupId);
                        sb.append(" and classNameId = ");
                        sb.append(classNameId);
                        sb.append(" and classPK = ");
                        sb.append(classPK);
                        sb.append(" and name = '");
                        sb.append(name);
                        sb.append("' and startPeriod = ");
                        sb.append(startPeriod);
                        this.runSQL(sb.toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                var5_7 = throwable3;
                throw throwable3;
            }
            finally {
                if (ps != null) {
                    if (var5_7 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
    }

    protected void migrateEquitySettings() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select groupId, companyId, classNameId, actionId, dailyLimit, type_, value from SocialEquitySetting");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long classNameId = rs.getLong("classNameId");
                String actionId = rs.getString("actionId");
                int dailyLimit = rs.getInt("dailyLimit");
                int type = rs.getInt("type_");
                int value = rs.getInt("value");
                Tuple tuple = this._equityToActivityMap.get(this.encodeEquityToActivityKey(classNameId, actionId));
                if (tuple == null) {
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unknown Social Equity setting with action ");
                    sb.append(actionId);
                    sb.append("for ");
                    String className = PortalUtil.getClassName((long)classNameId);
                    sb.append(className);
                    sb.append(". Please configure this action using the ");
                    sb.append("Social Activity portlet in the Control Panel.");
                    _log.warn((Object)sb.toString());
                    continue;
                }
                long activityClassNameId = GetterUtil.getLong((Object)tuple.getObject(0));
                int activityType = GetterUtil.getInteger((Object)tuple.getObject(1));
                if (type == 1) {
                    this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "contribution", 3, dailyLimit, value);
                    this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "popularity", 2, dailyLimit, value);
                    continue;
                }
                if (type != 2) continue;
                this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "participation", 1, dailyLimit, value);
            }
        }
    }

    protected void putEquityToActivityMap(String equityClassName, String equityActionId, int activityType) {
        this.putEquityToActivityMap(equityClassName, equityActionId, equityClassName, activityType);
    }

    protected void putEquityToActivityMap(String equityClassName, String equityActionId, String activityClassName, int activityType) {
        long equityClassNameId = PortalUtil.getClassNameId((String)equityClassName);
        long activityClassNameId = PortalUtil.getClassNameId((String)activityClassName);
        this._equityToActivityMap.put(this.encodeEquityToActivityKey(equityClassNameId, equityActionId), new Tuple(new Object[]{activityClassNameId, activityType}));
    }

    protected void updateActivityCounter(long activityCounterId, long groupId, long companyId, long classNameId, long classPK, String name, int ownerType, int startPeriod, int endPeriod, int increment) throws Exception {
        Object[] activityCounter = this.getActivityCounter(groupId, classNameId, classPK, name, ownerType, startPeriod, endPeriod);
        if (activityCounter == null) {
            int totalValue = this.getTotalValue(groupId, classNameId, classPK, name, ownerType, startPeriod);
            this.addActivityCounter(activityCounterId, groupId, companyId, classNameId, classPK, name, ownerType, increment, totalValue + increment, 0, startPeriod, endPeriod);
            return;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("update SocialActivityCounter set currentValue = ");
        sb.append("currentValue + ");
        sb.append(increment);
        sb.append(", totalValue = totalValue + ");
        sb.append(increment);
        sb.append(" where activityCounterId = ");
        activityCounterId = GetterUtil.getLong((Object)activityCounter[0]);
        sb.append(activityCounterId);
        this.runSQL(sb.toString());
    }
}

