/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.CamelCaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v6_1_0.UpgradeCommunityProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradePortletPreferences
extends CamelCaseUpgradePortletPreferences {
    private static final String[] _CAMEL_CASE_UPGRADE_PORTLET_IDS = new String[]{"15", "19", "20", "33", "34", "36", "39_INSTANCE_%", "47_INSTANCE_%", "48_INSTANCE_%", "54_INSTANCE_%", "56_INSTANCE_%", "59_INSTANCE_%", "62_INSTANCE_%", "71_INSTANCE_%", "73_INSTANCE_%", "77", "82_INSTANCE_%", "85_INSTANCE_%", "100", "101_INSTANCE_%", "102_INSTANCE_%", "114", "115", "118_INSTANCE_%", "122_INSTANCE_%"};

    protected void addPortalPreferences(long ownerId, int ownerType, String preferences) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into PortalPreferences (portalPreferencesId, ownerId, ownerType, preferences) values (?, ?, ?, ?)");){
            ps.setLong(1, this.increment());
            ps.setLong(2, ownerId);
            ps.setInt(3, ownerType);
            ps.setString(4, preferences);
            ps.executeUpdate();
        }
    }

    protected void addPortletPreferences(long ownerId, int ownerType, long plid, String portletId, String preferences) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into PortletPreferences (portletPreferencesId, ownerId, ownerType, plid, portletId, preferences) values (?, ?, ?, ?, ?, ?)");){
            ps.setLong(1, this.increment());
            ps.setLong(2, ownerId);
            ps.setInt(3, ownerType);
            ps.setLong(4, plid);
            ps.setString(5, portletId);
            ps.setString(6, preferences);
            ps.executeUpdate();
        }
    }

    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("create index IX_D1F795F1 on PortalPreferences (ownerId, ownerType)");
        }
    }

    protected void doUpgrade() throws Exception {
        super.doUpgrade();
        this.updatePortalPreferences();
        this.updatePortletPreferencesOwner();
        this.upgrade(UpgradeCommunityProperties.class);
        this.createIndex();
    }

    protected long getOwnerId(long plid) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId from Layout where plid = " + plid);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                long l = rs.getLong("groupId");
                return l;
            }
        }
        return 0L;
    }

    protected String[] getPortletIds() {
        return _CAMEL_CASE_UPGRADE_PORTLET_IDS;
    }

    protected long getPortletPreferencesId(long ownerId, int ownerType, long plid, String portletId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select portletPreferencesId from PortletPreferences where ownerId = ? and ownerType = ? and plid = ? and portletId = ?");){
            ps.setLong(1, ownerId);
            ps.setInt(2, ownerType);
            ps.setLong(3, plid);
            ps.setString(4, portletId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long l = rs.getLong("portletPreferencesId");
                    return l;
                }
            }
        }
        return 0L;
    }

    protected void updatePortalPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select ownerId, ownerType, preferences from PortletPreferences where portletId = ?");){
            ps.setString(1, "LIFERAY_PORTAL");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long ownerId = rs.getLong("ownerId");
                    int ownerType = rs.getInt("ownerType");
                    String preferences = rs.getString("preferences");
                    this.addPortalPreferences(ownerId, ownerType, preferences);
                }
                this.runSQL("delete from PortletPreferences where portletId = 'LIFERAY_PORTAL'");
            }
        }
    }

    protected void updatePortletPreferencesOwner() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(6);
            sb.append("select portletPreferencesId, plid, portletId, ");
            sb.append("preferences from PortletPreferences where ownerId = ");
            sb.append(0L);
            sb.append(" and ownerType = ");
            sb.append(3);
            sb.append(" and portletId in ('8', '19', '33')");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long portletPreferencesId;
                    long plid = rs.getLong("plid");
                    String portletId = rs.getString("portletId");
                    String preferences = rs.getString("preferences");
                    long ownerId = this.getOwnerId(plid);
                    if (ownerId == 0L || (portletPreferencesId = this.getPortletPreferencesId(ownerId, 2, 0L, portletId)) != 0L) continue;
                    this.addPortletPreferences(ownerId, 2, 0L, portletId, preferences);
                }
            }
        }
    }
}

