/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.upgrade.v6_1_0.util.DLFileVersionTable;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Set;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);
    private static final Set<String> _imageMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);

    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.updateFileRanks();
        this.updateFileShortcuts();
        this.updateFileVersions();
        this.updateLocks();
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_AUTO_CREATE_ON_UPGRADE) {
            this.updateThumbnails();
        }
    }

    /*
     * Exception decompiling
     */
    protected long getFileEntryId(long groupId, long folderId, String name) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getGroupId(long folderId) throws Exception {
        long groupId = 0L;
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId from DLFolder where folderId = ?");){
            ps.setLong(1, folderId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    groupId = rs.getLong("groupId");
                }
            }
        }
        return groupId;
    }

    protected void updateFileEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select fileEntryId, extension from DLFileEntry");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                String extension = rs.getString("extension");
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                this.runSQL("update DLFileEntry set mimeType = '" + mimeType + "' where fileEntryId = " + fileEntryId);
            }
        }
    }

    protected void updateFileRanks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select groupId, fileRankId, folderId, name from DLFileRank");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long fileRankId = rs.getLong("fileRankId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                this.runSQL("update DLFileRank set fileEntryId = " + fileEntryId + " where fileRankId = " + fileRankId);
            }
            this.runSQL("alter table DLFileRank drop column folderId");
            this.runSQL("alter table DLFileRank drop column name");
        }
    }

    protected void updateFileShortcuts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select fileShortcutId, toFolderId, toName from DLFileShortcut");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long fileShortcutId = rs.getLong("fileShortcutId");
                long toFolderId = rs.getLong("toFolderId");
                String toName = rs.getString("toName");
                long groupId = this.getGroupId(toFolderId);
                long toFileEntryId = this.getFileEntryId(groupId, toFolderId, toName);
                this.runSQL("update DLFileShortcut set toFileEntryId = " + toFileEntryId + " where fileShortcutId = " + fileShortcutId);
            }
            this.runSQL("alter table DLFileShortcut drop column toFolderId");
            this.runSQL("alter table DLFileShortcut drop column toName");
        }
    }

    protected void updateFileVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            try (PreparedStatement ps = this.connection.prepareStatement("select groupId, fileVersionId, folderId, name, extension from DLFileVersion");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long fileVersionId = rs.getLong("fileVersionId");
                    long folderId = rs.getLong("folderId");
                    String name = rs.getString("name");
                    String extension = rs.getString("extension");
                    String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                    long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                    this.runSQL("update DLFileVersion set fileEntryId = " + fileEntryId + ", mimeType = '" + mimeType + "' where fileVersionId = " + fileVersionId);
                }
            }
            this.alter(DLFileVersionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "extraSettings", "TEXT null"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "title", "VARCHAR(255) null"), new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "name")});
        }
    }

    protected void updateLocks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select lockId, key_ from Lock_ where className = ?");){
            ps.setString(1, "com.liferay.portlet.documentlibrary.model.DLFileEntry");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name;
                    long folderId;
                    long groupId;
                    long fileEntryId;
                    long lockId = rs.getLong("lockId");
                    String key = rs.getString("key_");
                    String[] keyArray = StringUtil.split((String)key, (char)'#');
                    if (keyArray.length != 3 || (fileEntryId = this.getFileEntryId(groupId = GetterUtil.getLong((String)keyArray[0]), folderId = GetterUtil.getLong((String)keyArray[1]), name = keyArray[2])) <= 0L) continue;
                    this.runSQL("update Lock_ set key_ = '" + fileEntryId + "' where lockId = " + lockId);
                }
            }
        }
    }

    protected void updateThumbnails() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select fileEntryId from DLFileEntry");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                this.updateThumbnails(fileEntryId);
            }
        }
    }

    protected void updateThumbnails(long fileEntryId) throws Exception {
        block28: {
            try (PreparedStatement ps = this.connection.prepareStatement("select fileVersionId, userId, extension, mimeType, version from DLFileVersion where fileEntryId = " + fileEntryId + " order by version asc");){
                ResultSet rs = ps.executeQuery();
                Throwable throwable = null;
                block20: while (true) {
                    try {
                        while (rs.next()) {
                            long fileVersionId = rs.getLong("fileVersionId");
                            long userId = rs.getLong("userId");
                            String extension = rs.getString("extension");
                            String mimeType = rs.getString("mimeType");
                            String version = rs.getString("version");
                            if (!_imageMimeTypes.contains(mimeType)) continue;
                            DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
                            dlFileVersion.setFileVersionId(fileVersionId);
                            dlFileVersion.setUserId(userId);
                            dlFileVersion.setFileEntryId(fileEntryId);
                            dlFileVersion.setExtension(extension);
                            dlFileVersion.setMimeType(mimeType);
                            dlFileVersion.setVersion(version);
                            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileVersion);
                            try {
                                ImageProcessorUtil.generateImages(null, (FileVersion)fileVersion);
                                continue block20;
                            }
                            catch (Exception e) {
                                if (!_log.isWarnEnabled()) continue;
                                _log.warn((Object)("Unable to generate thumbnails for " + fileVersion.getFileVersionId()), (Throwable)e);
                            }
                        }
                        break block28;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
    }
}

