/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.portlet.PortletPreferences;

public class UpgradeAssetPublisher
extends BaseUpgradePortletPreferences {
    protected String[] getAssetEntryXmls(String[] assetEntryXmls) throws Exception {
        String[] newAssetEntryXmls = new String[assetEntryXmls.length];
        for (int i = 0; i < assetEntryXmls.length; ++i) {
            String assetEntryXml = assetEntryXmls[i];
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            this.upgradeToAssetEntryUuidElement(rootElement);
            newAssetEntryXmls[i] = document.formattedString("");
        }
        return newAssetEntryXmls;
    }

    protected String[] getPortletIds() {
        return new String[]{"101_INSTANCE_%"};
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        String selectionStyle = portletPreferences.getValue("selection-style", null);
        if (Validator.isNotNull((String)selectionStyle) && !selectionStyle.equals("dynamic")) {
            String[] assetEntryXmls = portletPreferences.getValues("asset-entry-xml", new String[0]);
            String[] newAssetEntryXmls = this.getAssetEntryXmls(assetEntryXmls);
            portletPreferences.setValues("asset-entry-xml", newAssetEntryXmls);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeToAssetEntryUuidElement(Element rootElement) throws Exception {
        Element assetEntryIdElement = rootElement.element("assetEntryId");
        long assetEntryId = GetterUtil.getLong((String)assetEntryIdElement.getText());
        try (PreparedStatement ps = this.connection.prepareStatement("select classUuid from AssetEntry where entryId = ?");){
            ps.setLong(1, assetEntryId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String classUuid = rs.getString("classUuid");
                    Element assetEntryUuidElement = rootElement.addElement("assetEntryUuid");
                    assetEntryUuidElement.addText(classUuid);
                    rootElement.remove(assetEntryIdElement);
                }
            }
        }
    }
}

