/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PortletDeployer
extends BaseDeployer {
    public static final String JSF_STANDARD = "javax.portlet.faces.GenericFacesPortlet";

    public static void main(String[] args) {
        ToolDependencies.wireDeployers();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        for (String arg : args) {
            if (arg.endsWith(".war")) {
                wars.add(arg);
                continue;
            }
            if (!arg.endsWith(".jar")) continue;
            jars.add(arg);
        }
        new PortletDeployer(wars, jars);
    }

    public PortletDeployer() {
    }

    public PortletDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.portletTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.portlet.taglib.dtd is not set");
        }
    }

    @Override
    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        super.copyXmls(srcFile, displayName, pluginPackage);
        this.copyTomcatContextXml(srcFile);
        this.copyDependencyXml("_servlet_context_include.jsp", srcFile + "/WEB-INF/jsp");
    }

    @Override
    public String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        StringBundler sb = new StringBundler();
        if (ServerDetector.isWebSphere()) {
            sb.append("<context-param>");
            sb.append("<param-name>");
            sb.append("com.ibm.websphere.portletcontainer.");
            sb.append("PortletDeploymentEnabled");
            sb.append("</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        File portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml");
        File webXML = new File(srcFile + "/WEB-INF/web.xml");
        this.updatePortletXML(portletXML);
        sb.append(this.getServletContent(portletXML, webXML));
        String extraContent = super.getExtraContent(webXmlVersion, srcFile, displayName);
        sb.append(extraContent);
        return sb.toString();
    }

    @Override
    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        StringBundler sb = new StringBundler(4);
        String extraFiltersContent = super.getExtraFiltersContent(webXmlVersion, srcFile);
        sb.append(extraFiltersContent);
        sb.append(this.getIgnoreFiltersContent(srcFile));
        sb.append(this.getSpeedFiltersContent(srcFile));
        sb.append(this.getServletContextIncludeFiltersContent(webXmlVersion, srcFile));
        return sb.toString();
    }

    @Override
    public String getPluginType() {
        return "portlet";
    }

    public String getServletContent(File portletXML, File webXML) throws Exception {
        StringBundler sb = new StringBundler();
        Document document = UnsecureSAXReaderUtil.read((File)portletXML);
        Element rootElement = document.getRootElement();
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String portletName = PortalUtil.getJsSafePortletId((String)portletElement.elementText("portlet-name"));
            String portletClassName = portletElement.elementText("portlet-class");
            String servletName = portletName + " Servlet";
            sb.append("<servlet>");
            sb.append("<servlet-name>");
            sb.append(servletName);
            sb.append("</servlet-name>");
            sb.append("<servlet-class>");
            sb.append("com.liferay.portal.kernel.servlet.PortletServlet");
            sb.append("</servlet-class>");
            sb.append("<init-param>");
            sb.append("<param-name>portlet-class</param-name>");
            sb.append("<param-value>");
            sb.append(portletClassName);
            sb.append("</param-value>");
            sb.append("</init-param>");
            sb.append("<load-on-startup>1</load-on-startup>");
            sb.append("</servlet>");
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append(servletName);
            sb.append("</servlet-name>");
            sb.append("<url-pattern>/");
            sb.append(portletName);
            sb.append("/*</url-pattern>");
            sb.append("</servlet-mapping>");
        }
        return sb.toString();
    }

    @Override
    public void updateDeployDirectory(File srcFile) throws Exception {
        boolean customPortletXML = false;
        try {
            customPortletXML = PrefsPropsUtil.getBoolean("auto.deploy.custom.portlet.xml", PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML);
        }
        catch (Exception e) {
            customPortletXML = PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML;
        }
        customPortletXML = GetterUtil.getBoolean((String)System.getProperty("deployer.custom.portlet.xml"), (boolean)customPortletXML);
        if (!customPortletXML) {
            return;
        }
        File portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml");
        if (portletXML.exists()) {
            File portletCustomXML = new File(srcFile + "/WEB-INF/" + "portlet-custom.xml");
            if (portletCustomXML.exists()) {
                portletCustomXML.delete();
            }
            portletXML.renameTo(portletCustomXML);
        }
    }

    public void updatePortletXML(File portletXML) throws Exception {
        if (!portletXML.exists()) {
            return;
        }
        String content = FileUtil.read((File)portletXML);
        content = StringUtil.replace((String)content, (String)"com.liferay.util.bridges.jsp.JSPPortlet", (String)MVCPortlet.class.getName());
        FileUtil.write((File)portletXML, (String)content);
    }
}

