/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.portal.tools.ImportsFormatter;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseImportsFormatter
implements ImportsFormatter {
    private static final Pattern _javaImportPattern = Pattern.compile("import( static)? ([^;]+);");

    @Override
    public String format(String content, Pattern importPattern) throws IOException {
        return this.doFormat(content, importPattern, null, null);
    }

    @Override
    public String format(String content, String packageDir, String className) throws IOException {
        return this.doFormat(content, null, packageDir, className);
    }

    protected abstract ImportPackage createImportPackage(String var1);

    protected ImportPackage createJavaImportPackage(String line) {
        Matcher matcher = _javaImportPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        boolean isStatic = false;
        if (Validator.isNotNull((String)matcher.group(1))) {
            isStatic = true;
        }
        String importString = matcher.group(2);
        return new ImportPackage(importString, isStatic, line);
    }

    protected abstract String doFormat(String var1, Pattern var2, String var3, String var4) throws IOException;

    protected String sortAndGroupImports(String imports) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("\n//")) {
            return imports + "\n";
        }
        TreeSet<ImportPackage> importPackages = new TreeSet<ImportPackage>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ImportPackage importPackage = this.createImportPackage(line);
            if (importPackage == null) continue;
            importPackages.add(importPackage);
        }
        StringBundler sb = new StringBundler(3 * importPackages.size());
        ImportPackage previousImportPackage = null;
        for (ImportPackage importPackage : importPackages) {
            if (previousImportPackage != null && !importPackage.isGroupedWith(previousImportPackage)) {
                sb.append("\n");
            }
            sb.append(importPackage.getLine());
            sb.append("\n");
            previousImportPackage = importPackage;
        }
        return sb.toString();
    }

    protected String stripUnusedImports(String imports, String content, String packageDir, String className, String classNameExceptionRegex) throws IOException {
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String importClass;
            int y;
            String importPackage;
            int x = line.indexOf("import ");
            if (x == -1 || (importPackage = line.substring(x + 7, y = line.lastIndexOf(46))).equals(packageDir) || importPackage.equals("java.lang") || !(importClass = line.substring(y + 1, line.length() - 1)).matches(classNameExceptionRegex) && !classes.contains(importClass)) continue;
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }
}

