/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.header;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.text.Format;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HeaderFilter
extends BasePortalFilter {
    private static final String _DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String _EXPIRES = "Expires";
    private static final Set<String> _requestHeaderIgnoreInitParams = SetUtil.fromArray((Object[])PropsValues.REQUEST_HEADER_IGNORE_INIT_PARAMS);
    private Format _dateFormat;
    private FilterConfig _filterConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._filterConfig = filterConfig;
        this._dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)_DATE_FORMAT, (Locale)LocaleUtil.US, (TimeZone)TimeZoneUtil.GMT);
    }

    protected long getLastModified(HttpServletRequest request) {
        long lasModified = -1L;
        Map parameterMap = HttpUtil.getParameterMap((String)request.getQueryString());
        Object[] value = (String[])parameterMap.get("t");
        if (ArrayUtil.isNotEmpty((Object[])value)) {
            lasModified = GetterUtil.getLong((String)value[0]);
        }
        return lasModified;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Enumeration enu = this._filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (_requestHeaderIgnoreInitParams.contains(name)) continue;
            String value = this._filterConfig.getInitParameter(name);
            if (name.equals(_EXPIRES) && Validator.isNumber((String)value)) {
                int seconds = GetterUtil.getInteger((String)value);
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(13, seconds);
                value = this._dateFormat.format(cal.getTime());
            }
            boolean addHeader = true;
            if (StringUtil.equalsIgnoreCase((String)name, (String)"Cache-Control") || StringUtil.equalsIgnoreCase((String)name, (String)_EXPIRES)) {
                boolean newSession = false;
                HttpSession session = request.getSession(false);
                if (session == null || session.isNew()) {
                    newSession = true;
                }
                String contextPath = request.getContextPath();
                if (StringUtil.equalsIgnoreCase((String)name, (String)_EXPIRES) && newSession) {
                    addHeader = false;
                } else if (PropsValues.WEB_SERVER_PROXY_LEGACY_MODE && newSession && contextPath.equals(PortalUtil.getPathContext())) {
                    addHeader = false;
                }
            }
            if (!addHeader) continue;
            response.addHeader(name, value);
        }
        long lastModified = this.getLastModified(request);
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (lastModified > 0L) {
            response.setDateHeader("Last-Modified", lastModified);
            if (lastModified <= ifModifiedSince) {
                response.setDateHeader("Last-Modified", ifModifiedSince);
                response.setStatus(304);
                return;
            }
        }
        this.processFilter(HeaderFilter.class.getName(), request, response, filterChain);
    }
}

