/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.adapter.builder;

import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilder;
import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilderLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ServiceTrackerMapModelAdapterBuilderLocator
implements ModelAdapterBuilderLocator,
Closeable {
    private final ServiceTrackerMap<String, ModelAdapterBuilder> _modelAdapterBuilders = ServiceTrackerCollections.openSingleValueMap(ModelAdapterBuilder.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, ModelAdapterBuilder>(){

        public void map(ServiceReference<ModelAdapterBuilder> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            ModelAdapterBuilder modelAdapterBuilder = (ModelAdapterBuilder)registry.getService(serviceReference);
            Type genericInterface = ReflectionUtil.getGenericInterface((Object)modelAdapterBuilder, ModelAdapterBuilder.class);
            if (genericInterface == null || !(genericInterface instanceof ParameterizedType)) {
                return;
            }
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            Object[] typeArguments = parameterizedType.getActualTypeArguments();
            if (ArrayUtil.isEmpty((Object[])typeArguments) || typeArguments.length != 2) {
                return;
            }
            try {
                Class adapteeModelClass = (Class)typeArguments[0];
                Class adaptedModelClass = (Class)typeArguments[1];
                emitter.emit((Object)ServiceTrackerMapModelAdapterBuilderLocator.this.getKey(adapteeModelClass, adaptedModelClass));
            }
            catch (ClassCastException cce) {
                return;
            }
        }
    });

    @Override
    public void close() {
        this._modelAdapterBuilders.close();
    }

    public <T, V> ModelAdapterBuilder<T, V> locate(Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return (ModelAdapterBuilder)this._modelAdapterBuilders.getService((Object)this.getKey(adapteeModelClass, adaptedModelClass));
    }

    private <T, V> String getKey(Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return adapteeModelClass.getName() + "->" + adaptedModelClass.getName();
    }
}

