/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.JavaScriptMinifier;

public class GoogleJavaScriptMinifier
implements JavaScriptMinifier {
    private static final Log _log = LogFactoryUtil.getLog(GoogleJavaScriptMinifier.class);

    @Override
    public String compress(String resourceName, String content) {
        Compiler compiler = new Compiler((ErrorManager)new LogErrorManager());
        compiler.disableThreads();
        SourceFile sourceFile = SourceFile.fromCode((String)resourceName, (String)content);
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5);
        compilerOptions.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        this.setCompileOptions(compilerOptions);
        compiler.compile(SourceFile.fromCode((String)"extern", (String)""), sourceFile, compilerOptions);
        return compiler.toSource();
    }

    protected void setCompileOptions(CompilerOptions compilerOptions) {
        compilerOptions.checkGlobalThisLevel = CheckLevel.OFF;
        compilerOptions.closurePass = true;
        compilerOptions.coalesceVariableNames = true;
        compilerOptions.collapseVariableDeclarations = true;
        compilerOptions.convertToDottedProperties = true;
        compilerOptions.deadAssignmentElimination = true;
        compilerOptions.flowSensitiveInlineVariables = true;
        compilerOptions.foldConstants = true;
        compilerOptions.labelRenaming = true;
        compilerOptions.removeDeadCode = true;
        compilerOptions.optimizeArgumentsArray = true;
        compilerOptions.setAssumeClosuresOnlyCaptureReferences(false);
        compilerOptions.setInlineFunctions(CompilerOptions.Reach.LOCAL_ONLY);
        compilerOptions.setInlineVariables(CompilerOptions.Reach.LOCAL_ONLY);
        compilerOptions.setRenamingPolicy(VariableRenamingPolicy.LOCAL, PropertyRenamingPolicy.OFF);
        compilerOptions.setRemoveUnusedVariables(CompilerOptions.Reach.LOCAL_ONLY);
    }

    private class LogErrorManager
    extends BasicErrorManager {
        private final MessageFormatter _simpleMessageFormatter = new SimpleMessageFormatter();

        private LogErrorManager() {
        }

        public void println(CheckLevel checkLevel, JSError jsError) {
            if (checkLevel == CheckLevel.ERROR) {
                _log.error((Object)jsError.format(checkLevel, this._simpleMessageFormatter));
            } else if (checkLevel == CheckLevel.WARNING && _log.isWarnEnabled()) {
                _log.warn((Object)jsError.format(checkLevel, this._simpleMessageFormatter));
            }
        }

        protected void printSummary() {
            if (this.getErrorCount() > 0) {
                _log.error((Object)this._buildMessage());
            } else if (_log.isWarnEnabled() && this.getWarningCount() > 0) {
                _log.warn((Object)this._buildMessage());
            }
        }

        private String _buildMessage() {
            return String.format("{0} error(s), {1} warning(s)", this.getErrorCount(), this.getWarningCount());
        }
    }

    private static class SimpleMessageFormatter
    implements MessageFormatter {
        private SimpleMessageFormatter() {
        }

        public String formatError(JSError jsError) {
            return String.format("(%s:%d): %s", jsError.sourceName, jsError.lineNumber, jsError.description);
        }

        public String formatWarning(JSError jsError) {
            return this.formatError(jsError);
        }
    }
}

