/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheMapSynchronizeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class LanguageImpl
implements Language,
Serializable {
    private static final Log _log = LogFactoryUtil.getLog(LanguageImpl.class);
    private static final Map<Long, CompanyLocalesBag> _companyLocalesBags = new ConcurrentHashMap<Long, CompanyLocalesBag>();
    private static final Pattern _pattern = Pattern.compile("Liferay\\.Language\\.get\\([\"']([^)]+)[\"']\\)");
    private static PortalCache<Long, Serializable> _portalCache;
    private final Map<Long, Map<String, Locale>> _groupLanguageCodeLocalesMapMap = new ConcurrentHashMap<Long, Map<String, Locale>>();
    private final Map<Long, Map<String, Locale>> _groupLanguageIdLocalesMap = new ConcurrentHashMap<Long, Map<String, Locale>>();

    public void afterPropertiesSet() {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                Registry registry = RegistryUtil.getRegistry();
                MultiVMPool multiVMPool = (MultiVMPool)registry.getService(MultiVMPool.class);
                _portalCache = multiVMPool.getPortalCache(LanguageImpl.class.getName());
                PortalCacheMapSynchronizeUtil.synchronize((PortalCache)_portalCache, (Map)_companyLocalesBags, (PortalCacheMapSynchronizeUtil.Synchronizer)new PortalCacheMapSynchronizeUtil.Synchronizer<Long, Serializable>(){

                    public void onSynchronize(Map<? extends Long, ? extends Serializable> map, Long key, Serializable value, int timeToLive) {
                        _companyLocalesBags.remove(key);
                    }
                });
            }

            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(new Class[]{MultiVMPool.class});
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper argument) {
        return this.format(request, pattern, new LanguageWrapper[]{argument}, true);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return this.format(request, pattern, new LanguageWrapper[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments) {
        return this.format(request, pattern, arguments, true);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(request, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? arguments[i].getBefore() + this.get(request, arguments[i].getText()) + arguments[i].getAfter() : arguments[i].getBefore() + arguments[i].getText() + arguments[i].getAfter();
                    }
                    MessageFormat messageFormat = this.decorateMessageFormat(request, pattern, formattedArguments);
                    value = messageFormat.format(formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(HttpServletRequest request, String pattern, Object argument) {
        return this.format(request, pattern, new Object[]{argument}, true);
    }

    public String format(HttpServletRequest request, String pattern, Object argument, boolean translateArguments) {
        return this.format(request, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest request, String pattern, Object[] arguments) {
        return this.format(request, pattern, arguments, true);
    }

    public String format(HttpServletRequest request, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(request, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(request, arguments[i].toString()) : arguments[i];
                    }
                    MessageFormat messageFormat = this.decorateMessageFormat(request, pattern, formattedArguments);
                    value = messageFormat.format(formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(Locale locale, String pattern, List<Object> arguments) {
        return this.format(locale, pattern, arguments.toArray(), true);
    }

    public String format(Locale locale, String pattern, Object argument) {
        return this.format(locale, pattern, new Object[]{argument}, true);
    }

    public String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(Locale locale, String pattern, Object[] arguments) {
        return this.format(locale, pattern, arguments, true);
    }

    public String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(locale, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(locale, arguments[i].toString()) : arguments[i];
                    }
                    MessageFormat messageFormat = this.decorateMessageFormat(locale, pattern, formattedArguments);
                    value = messageFormat.format(formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument, boolean translateArguments) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments) {
        return this.format(resourceBundle, pattern, arguments, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(resourceBundle, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(resourceBundle, arguments[i].toString()) : arguments[i];
                    }
                    MessageFormat messageFormat = this.decorateMessageFormat(resourceBundle.getLocale(), pattern, formattedArguments);
                    value = messageFormat.format(formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String get(HttpServletRequest request, ResourceBundle resourceBundle, String key) {
        return this.get(request, resourceBundle, key, key);
    }

    public String get(HttpServletRequest request, ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = this._get(resourceBundle, key);
        if (value != null) {
            return value;
        }
        return this.get(request, key, defaultValue);
    }

    public String get(HttpServletRequest request, String key) {
        return this.get(request, key, key);
    }

    public String get(HttpServletRequest request, String key, String defaultValue) {
        if (request == null || key == null) {
            return defaultValue;
        }
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        Locale locale = this._getLocale(request);
        if (portletConfig == null) {
            return this.get(locale, key, defaultValue);
        }
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        if (resourceBundle.containsKey(key)) {
            return this._get(resourceBundle, key);
        }
        return this.get(locale, key, defaultValue);
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, key);
    }

    public String get(Locale locale, String key, String defaultValue) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (locale == null || key == null) {
            return defaultValue;
        }
        String value = LanguageResources.getMessage(locale, key);
        if (value != null) {
            return LanguageResources.fixValue(value);
        }
        if (value == null && key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this.get(locale, key, defaultValue);
        }
        return defaultValue;
    }

    public String get(ResourceBundle resourceBundle, String key) {
        return this.get(resourceBundle, key, key);
    }

    public String get(ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = this._get(resourceBundle, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Set<Locale> getAvailableLocales() {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.getAvailableLocales();
    }

    public Set<Locale> getAvailableLocales(long groupId) {
        if (groupId <= 0L) {
            return this.getAvailableLocales();
        }
        try {
            if (this.isInheritLocales(groupId)) {
                return this.getAvailableLocales();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Map<String, Locale> groupLanguageIdLocalesMap = this._getGroupLanguageIdLocalesMap(groupId);
        return new HashSet<Locale>(groupLanguageIdLocalesMap.values());
    }

    public String getBCP47LanguageId(HttpServletRequest request) {
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getBCP47LanguageId(locale);
    }

    public String getBCP47LanguageId(Locale locale) {
        return LocaleUtil.toBCP47LanguageId((Locale)locale);
    }

    public String getBCP47LanguageId(PortletRequest portletRequest) {
        Locale locale = PortalUtil.getLocale((PortletRequest)portletRequest);
        return this.getBCP47LanguageId(locale);
    }

    public String getLanguageId(HttpServletRequest request) {
        CompanyLocalesBag companyLocalesBag;
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        if (Validator.isNotNull((String)languageId) && ((companyLocalesBag = LanguageImpl._getCompanyLocalesBag()).containsLanguageCode(languageId) || companyLocalesBag.containsLanguageId(languageId))) {
            return languageId;
        }
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getLanguageId(locale);
    }

    public String getLanguageId(Locale locale) {
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    public String getLanguageId(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getLanguageId(request);
    }

    public Locale getLocale(long groupId, String languageCode) {
        Map<String, Locale> groupLanguageCodeLocalesMap = this._getGroupLanguageCodeLocalesMap(groupId);
        return groupLanguageCodeLocalesMap.get(languageCode);
    }

    public Locale getLocale(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.getByLanguageCode(languageCode);
    }

    public ResourceBundleLoader getPortalResourceBundleLoader() {
        return LanguageResources.RESOURCE_BUNDLE_LOADER;
    }

    public Set<Locale> getSupportedLocales() {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag._supportedLocalesSet;
    }

    public String getTimeDescription(HttpServletRequest request, long milliseconds) {
        return this.getTimeDescription(request, milliseconds, false);
    }

    public String getTimeDescription(HttpServletRequest request, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(request, StringUtil.toLowerCase((String)description.substring(pos + 1, description.length()))));
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String getTimeDescription(HttpServletRequest request, Long milliseconds) {
        return this.getTimeDescription(request, (long)milliseconds);
    }

    public String getTimeDescription(Locale locale, long milliseconds) {
        return this.getTimeDescription(locale, milliseconds, false);
    }

    public String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(locale, StringUtil.toLowerCase((String)description.substring(pos + 1, description.length()))));
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String getTimeDescription(Locale locale, Long milliseconds) {
        return this.getTimeDescription(locale, (long)milliseconds);
    }

    public void init() {
        _companyLocalesBags.clear();
    }

    public boolean isAvailableLanguageCode(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.containsLanguageCode(languageCode);
    }

    public boolean isAvailableLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        return this.isAvailableLocale(LocaleUtil.toLanguageId((Locale)locale));
    }

    public boolean isAvailableLocale(long groupId, Locale locale) {
        if (locale == null) {
            return false;
        }
        return this.isAvailableLocale(groupId, LocaleUtil.toLanguageId((Locale)locale));
    }

    public boolean isAvailableLocale(long groupId, String languageId) {
        if (groupId <= 0L) {
            return this.isAvailableLocale(languageId);
        }
        try {
            if (this.isInheritLocales(groupId)) {
                return this.isAvailableLocale(languageId);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Map<String, Locale> groupLanguageIdLocalesMap = this._getGroupLanguageIdLocalesMap(groupId);
        return groupLanguageIdLocalesMap.containsKey(languageId);
    }

    public boolean isAvailableLocale(String languageId) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.containsLanguageId(languageId);
    }

    public boolean isBetaLocale(Locale locale) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.isBetaLocale(locale);
    }

    public boolean isDuplicateLanguageCode(String languageCode) {
        CompanyLocalesBag companyLocalesBag = LanguageImpl._getCompanyLocalesBag();
        return companyLocalesBag.isDuplicateLanguageCode(languageCode);
    }

    public boolean isInheritLocales(long groupId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!group.isSite() || group.isCompany()) {
            return true;
        }
        return GetterUtil.getBoolean((String)group.getTypeSettingsProperty("inheritLocales"), (boolean)true);
    }

    public String process(ResourceBundle resourceBundle, Locale locale, String content) {
        StringBundler sb = new StringBundler();
        Matcher matcher = _pattern.matcher(content);
        int x = 0;
        while (matcher.find()) {
            int y = matcher.start(0);
            String key = matcher.group(1);
            sb.append(content.substring(x, y));
            sb.append("'");
            String value = this.get(resourceBundle, key);
            sb.append(HtmlUtil.escapeJS((String)value));
            sb.append("'");
            x = matcher.end(0);
        }
        sb.append(content.substring(x));
        return sb.toString();
    }

    public void resetAvailableGroupLocales(long groupId) {
        this._resetAvailableGroupLocales(groupId);
    }

    public void resetAvailableLocales(long companyId) {
        this._resetAvailableLocales(companyId);
    }

    public void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        Cookie languageIdCookie = new Cookie("GUEST_LANGUAGE_ID", languageId);
        languageIdCookie.setPath("/");
        languageIdCookie.setMaxAge(31536000);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)languageIdCookie);
    }

    protected MessageFormat decorateMessageFormat(HttpServletRequest request, String pattern, Object[] formattedArguments) {
        Locale locale = this._getLocale(request);
        return this.decorateMessageFormat(locale, pattern, formattedArguments);
    }

    protected MessageFormat decorateMessageFormat(Locale locale, String pattern, Object[] formattedArguments) {
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        MessageFormat messageFormat = new MessageFormat(pattern, locale);
        for (int i = 0; i < formattedArguments.length; ++i) {
            Object formattedArgument = formattedArguments[i];
            if (!(formattedArgument instanceof Number)) continue;
            messageFormat.setFormat(i, NumberFormat.getInstance(locale));
        }
        return messageFormat;
    }

    private static CompanyLocalesBag _getCompanyLocalesBag() {
        Long companyId = CompanyThreadLocal.getCompanyId();
        CompanyLocalesBag companyLocalesBag = _companyLocalesBags.get(companyId);
        if (companyLocalesBag == null) {
            companyLocalesBag = new CompanyLocalesBag(companyId);
            _companyLocalesBags.put(companyId, companyLocalesBag);
        }
        return companyLocalesBag;
    }

    private ObjectValuePair<Map<String, Locale>, Map<String, Locale>> _createGroupLocales(long groupId) {
        String[] languageIds = PropsValues.LOCALES_ENABLED;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            languageIds = StringUtil.split((String)typeSettingsProperties.getProperty("locales"));
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Locale> groupLanguageCodeLocalesMap = new HashMap<String, Locale>();
        HashMap<String, Locale> groupLanguageIdLocalesMap = new HashMap<String, Locale>();
        for (String languageId : languageIds) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            String languageCode = languageId;
            int pos = languageId.indexOf(95);
            if (pos > 0) {
                languageCode = languageId.substring(0, pos);
            }
            if (!groupLanguageCodeLocalesMap.containsKey(languageCode)) {
                groupLanguageCodeLocalesMap.put(languageCode, locale);
            }
            groupLanguageIdLocalesMap.put(languageId, locale);
        }
        this._groupLanguageCodeLocalesMapMap.put(groupId, groupLanguageCodeLocalesMap);
        this._groupLanguageIdLocalesMap.put(groupId, groupLanguageIdLocalesMap);
        return new ObjectValuePair(groupLanguageCodeLocalesMap, groupLanguageIdLocalesMap);
    }

    private String _escapePattern(String pattern) {
        return StringUtil.replace((String)pattern, (char)'\'', (String)"''");
    }

    private String _get(ResourceBundle resourceBundle, String key) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (resourceBundle == null || key == null) {
            return null;
        }
        String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        if (value != null) {
            return LanguageResources.fixValue(value);
        }
        if (key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this._get(resourceBundle, key);
        }
        return null;
    }

    private Map<String, Locale> _getGroupLanguageCodeLocalesMap(long groupId) {
        Map groupLanguageCodeLocalesMap = this._groupLanguageCodeLocalesMapMap.get(groupId);
        if (groupLanguageCodeLocalesMap == null) {
            ObjectValuePair<Map<String, Locale>, Map<String, Locale>> objectValuePair = this._createGroupLocales(groupId);
            groupLanguageCodeLocalesMap = (Map)objectValuePair.getKey();
        }
        return groupLanguageCodeLocalesMap;
    }

    private Map<String, Locale> _getGroupLanguageIdLocalesMap(long groupId) {
        Map groupLanguageIdLocalesMap = this._groupLanguageIdLocalesMap.get(groupId);
        if (groupLanguageIdLocalesMap == null) {
            ObjectValuePair<Map<String, Locale>, Map<String, Locale>> objectValuePair = this._createGroupLocales(groupId);
            groupLanguageIdLocalesMap = (Map)objectValuePair.getValue();
        }
        return groupLanguageIdLocalesMap;
    }

    private Locale _getLocale(HttpServletRequest request) {
        Locale locale = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            locale = themeDisplay.getLocale();
        } else {
            locale = request.getLocale();
            if (!this.isAvailableLocale(locale)) {
                locale = LocaleUtil.getDefault();
            }
        }
        return locale;
    }

    private void _resetAvailableGroupLocales(long groupId) {
        this._groupLanguageCodeLocalesMapMap.remove(groupId);
        this._groupLanguageIdLocalesMap.remove(groupId);
    }

    private void _resetAvailableLocales(long companyId) {
        _portalCache.remove((Serializable)Long.valueOf(companyId));
    }

    private static class CompanyLocalesBag
    implements Serializable {
        private final Set<String> _duplicateLanguageCodes = new HashSet<String>();
        private final Map<String, Locale> _languageCodeLocalesMap = new HashMap<String, Locale>();
        private final Map<String, Locale> _languageIdLocalesMap = new HashMap<String, Locale>();
        private final Set<Locale> _localesBetaSet = new HashSet<Locale>();
        private final Set<Locale> _supportedLocalesSet;

        public boolean containsLanguageCode(String languageCode) {
            return this._languageCodeLocalesMap.containsKey(languageCode);
        }

        public boolean containsLanguageId(String languageId) {
            return this._languageIdLocalesMap.containsKey(languageId);
        }

        public Set<Locale> getAvailableLocales() {
            return new HashSet<Locale>(this._languageIdLocalesMap.values());
        }

        public Locale getByLanguageCode(String languageCode) {
            return this._languageCodeLocalesMap.get(languageCode);
        }

        public boolean isBetaLocale(Locale locale) {
            return this._localesBetaSet.contains(locale);
        }

        public boolean isDuplicateLanguageCode(String languageCode) {
            return this._duplicateLanguageCodes.contains(languageCode);
        }

        private CompanyLocalesBag(long companyId) {
            String[] languageIds = PropsValues.LOCALES;
            if (companyId != 0L) {
                try {
                    languageIds = PrefsPropsUtil.getStringArray(companyId, "locales", ",", PropsValues.LOCALES_ENABLED);
                }
                catch (SystemException se) {
                    languageIds = PropsValues.LOCALES_ENABLED;
                }
            }
            for (String languageId : languageIds) {
                Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
                String languageCode = languageId;
                int pos = languageId.indexOf(95);
                if (pos > 0) {
                    languageCode = languageId.substring(0, pos);
                }
                if (this._languageCodeLocalesMap.containsKey(languageCode)) {
                    this._duplicateLanguageCodes.add(languageCode);
                } else {
                    this._languageCodeLocalesMap.put(languageCode, locale);
                }
                this._languageIdLocalesMap.put(languageId, locale);
            }
            for (String languageId : PropsValues.LOCALES_BETA) {
                this._localesBetaSet.add(LocaleUtil.fromLanguageId((String)languageId, (boolean)false));
            }
            this._supportedLocalesSet = new HashSet<Locale>(this._languageIdLocalesMap.values());
            this._supportedLocalesSet.removeAll(this._localesBetaSet);
        }
    }
}

