/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceScannerStrategy;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AdvisedSupportProxy;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;

public class SpringJSONWebServiceScannerStrategy
implements JSONWebServiceScannerStrategy {
    public JSONWebServiceScannerStrategy.MethodDescriptor[] scan(Object service) {
        Class<?> clazz = null;
        try {
            clazz = this.getTargetClass(service);
        }
        catch (Exception e) {
            return new JSONWebServiceScannerStrategy.MethodDescriptor[0];
        }
        Method[] methods = clazz.getMethods();
        ArrayList<JSONWebServiceScannerStrategy.MethodDescriptor> methodDescriptors = new ArrayList<JSONWebServiceScannerStrategy.MethodDescriptor>(methods.length);
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != clazz || !this.isInterfaceMethod(method)) continue;
            methodDescriptors.add(new JSONWebServiceScannerStrategy.MethodDescriptor(method));
        }
        return methodDescriptors.toArray(new JSONWebServiceScannerStrategy.MethodDescriptor[methodDescriptors.size()]);
    }

    protected Class<?> getTargetClass(Object service) throws Exception {
        while (ProxyUtil.isProxyClass(service.getClass())) {
            InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)service);
            if (invocationHandler instanceof AdvisedSupportProxy) {
                AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(service);
                TargetSource targetSource = advisedSupport.getTargetSource();
                service = targetSource.getTarget();
                continue;
            }
            if (!(invocationHandler instanceof ClassLoaderBeanHandler)) continue;
            ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
            Object bean = classLoaderBeanHandler.getBean();
            if (bean instanceof ServiceWrapper) {
                ServiceWrapper serviceWrapper = (ServiceWrapper)bean;
                service = serviceWrapper.getWrappedService();
                continue;
            }
            service = bean;
        }
        return service.getClass();
    }

    protected boolean isInterfaceMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isInterface()) {
            return true;
        }
        LinkedList queue = new LinkedList(Arrays.asList(declaringClass.getInterfaces()));
        Class<Object> superClass = declaringClass.getSuperclass();
        if (superClass != null) {
            queue.add(superClass);
        }
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            if (clazz.isInterface()) {
                try {
                    clazz.getMethod(method.getName(), method.getParameterTypes());
                    return true;
                }
                catch (ReflectiveOperationException roe) {
                    continue;
                }
            }
            queue.addAll(Arrays.asList(clazz.getInterfaces()));
            superClass = clazz.getSuperclass();
            if (superClass == null) continue;
            queue.add(superClass);
        }
        return false;
    }
}

