/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.spring;

import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ConnectionUtil {
    private static final Method _closeMethod;
    private static final Class<?>[] _interfaces;

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        if (connection != null) {
            return (Connection)ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])_interfaces, (InvocationHandler)new UncloseableInvocationHandler(connection));
        }
        return dataSource.getConnection();
    }

    static {
        _interfaces = new Class[]{Connection.class};
        try {
            _closeMethod = Connection.class.getMethod("close", new Class[0]);
        }
        catch (ReflectiveOperationException roe) {
            throw new ExceptionInInitializerError(roe);
        }
    }

    private static class UncloseableInvocationHandler
    implements InvocationHandler {
        private final Connection _connection;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_closeMethod)) {
                return null;
            }
            return method.invoke((Object)this._connection, args);
        }

        private UncloseableInvocationHandler(Connection connection) {
            this._connection = connection;
        }
    }
}

