/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.compiler.ASTInspector;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private final int location;

    public LocalAsgnNode(ISourcePosition position, String name2, int location, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
        this.location = ASTInspector.PRAGMAS.contains(name2) ? -1 : location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LOCALASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return LocalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        if (this.location == -1) {
            return runtime.getNil();
        }
        return context.getCurrentScope().setValue(this.getIndex(), this.getValueNode().interpret(runtime, context, self2, aBlock), this.getDepth());
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        context.getCurrentScope().setValue(this.getIndex(), value2, this.getDepth());
        return runtime.getNil();
    }
}

