/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DefaultLayoutPrototypesUtil {
    public static Layout addLayout(LayoutSet layoutSet, String nameKey, String friendlyURL, String layouteTemplateId) throws Exception {
        Group group = layoutSet.getGroup();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            nameMap.put(locale, LanguageUtil.get(locale, nameKey));
        }
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getDefault(), friendlyURL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout(group.getCreatorUserId(), group.getGroupId(), layoutSet.isPrivateLayout(), 0L, nameMap, null, null, null, null, "portlet", "", false, friendlyURLMap, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layouteTemplateId, false);
        return layout;
    }

    public static Layout addLayoutPrototype(long companyId, long defaultUserId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String layouteTemplateId, List<LayoutPrototype> layoutPrototypes) throws Exception {
        String name = nameMap.get(LocaleUtil.getDefault());
        String description = descriptionMap.get(LocaleUtil.getDefault());
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            String curName = layoutPrototype.getName(LocaleUtil.getDefault());
            String curDescription = layoutPrototype.getDescription(LocaleUtil.getDefault());
            if (!name.equals(curName) || !description.equals(curDescription)) continue;
            return null;
        }
        LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype(defaultUserId, companyId, nameMap, descriptionMap, true, new ServiceContext());
        Layout layout = layoutPrototype.getLayout();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layouteTemplateId, false);
        return layout;
    }

    public static String addPortletId(Layout layout, String portletId, String columnId) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        portletId = layoutTypePortlet.addPortletId(0L, portletId, columnId, -1, false);
        DefaultLayoutPrototypesUtil.updateLayout(layout);
        DefaultLayoutPrototypesUtil.addResourcePermissions(layout, portletId);
        return portletId;
    }

    public static PortletPreferences updatePortletSetup(Layout layout, String portletId, Map<String, String> preferences) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup(layout, portletId);
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            portletSetup.setValue(key, value);
        }
        portletSetup.store();
        return portletSetup;
    }

    protected static void addResourcePermissions(Layout layout, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(layout.getCompanyId(), portletId);
        PortalUtil.addPortletDefaultResource(layout.getCompanyId(), layout, portlet);
    }

    protected static void updateLayout(Layout layout) throws Exception {
        LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
    }
}

