/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AggregateResourceBundleLoader
implements ResourceBundleLoader {
    private final ResourceBundleLoader[] _resourceBundleLoaders;

    public AggregateResourceBundleLoader(ResourceBundleLoader ... resourceBundleLoaders) {
        this._resourceBundleLoaders = resourceBundleLoaders;
    }

    @Override
    public ResourceBundle loadResourceBundle(String languageId) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (ResourceBundleLoader resourceBundleLoader : this._resourceBundleLoaders) {
            try {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(languageId);
                if (resourceBundle == null) continue;
                resourceBundles.add(resourceBundle);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (resourceBundles.isEmpty()) {
            throw new MissingResourceException("Resource bundle loader " + this + " was unable to load " + "resource bundle for " + languageId, "", languageId);
        }
        if (resourceBundles.size() == 1) {
            return (ResourceBundle)resourceBundles.get(0);
        }
        return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[resourceBundles.size()]));
    }
}

