/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.trash;

import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class TrashHandlerRegistryUtil {
    private static final TrashHandlerRegistryUtil _instance = new TrashHandlerRegistryUtil();
    private final ServiceRegistrationMap<TrashHandler> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<TrashHandler, TrashHandler> _serviceTracker;
    private final Map<String, TrashHandler> _trashHandlers = new ConcurrentSkipListMap<String, TrashHandler>();

    public static TrashHandler getTrashHandler(String className) {
        return _instance._getTrashHandler(className);
    }

    public static List<TrashHandler> getTrashHandlers() {
        return _instance._getTrashHandlers();
    }

    public static void register(List<TrashHandler> trashHandlers) {
        for (TrashHandler trashHandler : trashHandlers) {
            TrashHandlerRegistryUtil.register(trashHandler);
        }
    }

    public static void register(TrashHandler trashHandler) {
        _instance._register(trashHandler);
    }

    public static void unregister(List<TrashHandler> trashHandlers) {
        for (TrashHandler trashHandler : trashHandlers) {
            TrashHandlerRegistryUtil.unregister(trashHandler);
        }
    }

    public static void unregister(TrashHandler trashHandler) {
        _instance._unregister(trashHandler);
    }

    private TrashHandlerRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(TrashHandler.class, (ServiceTrackerCustomizer)new TrashHandlerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private TrashHandler _getTrashHandler(String className) {
        return this._trashHandlers.get(className);
    }

    private List<TrashHandler> _getTrashHandlers() {
        return ListUtil.fromMapValues(this._trashHandlers);
    }

    private void _register(TrashHandler trashHandler) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(TrashHandler.class, (Object)trashHandler);
        this._serviceRegistrations.put((Object)trashHandler, (Object)serviceRegistration);
    }

    private void _unregister(TrashHandler trashHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)trashHandler);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class TrashHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TrashHandler, TrashHandler> {
        private TrashHandlerServiceTrackerCustomizer() {
        }

        public TrashHandler addingService(ServiceReference<TrashHandler> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            TrashHandler trashHandler = (TrashHandler)registry.getService(serviceReference);
            TrashHandlerRegistryUtil.this._trashHandlers.put(trashHandler.getClassName(), trashHandler);
            return trashHandler;
        }

        public void modifiedService(ServiceReference<TrashHandler> serviceReference, TrashHandler trashHandler) {
        }

        public void removedService(ServiceReference<TrashHandler> serviceReference, TrashHandler trashHandler) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            TrashHandlerRegistryUtil.this._trashHandlers.remove(trashHandler.getClassName());
        }
    }
}

