/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.util.StringPool;

public class TransactionConfig {
    private final Isolation _isolation;
    private final Class<?>[] _noRollbackForClasses;
    private final String[] _noRollbackForClassNames;
    private final Propagation _propagation;
    private final boolean _readOnly;
    private final Class<?>[] _rollbackForClasses;
    private final String[] _rollbackForClassNames;
    private final int _timeout;

    public Isolation getIsolation() {
        return this._isolation;
    }

    public Class<?>[] getNoRollbackForClasses() {
        return this._noRollbackForClasses;
    }

    public String[] getNoRollbackForClassNames() {
        return this._noRollbackForClassNames;
    }

    public Propagation getPropagation() {
        return this._propagation;
    }

    public Class<?>[] getRollbackForClasses() {
        return this._rollbackForClasses;
    }

    public String[] getRollbackForClassNames() {
        return this._rollbackForClassNames;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    private TransactionConfig(Builder builder) {
        this._isolation = builder._isolation;
        this._noRollbackForClassNames = builder._noRollbackForClassNames;
        this._noRollbackForClasses = builder._noRollbackForClasses;
        this._propagation = builder._propagation;
        this._readOnly = builder._readOnly;
        this._rollbackForClassNames = builder._rollbackForClassNames;
        this._rollbackForClasses = builder._rollbackForClasses;
        this._timeout = builder._timeout;
    }

    public static class Factory {
        public static TransactionConfig create(Isolation isolation, Propagation propagation, boolean readOnly, int timeout, Class<?>[] rollbackForClasses, String[] rollbackForClassNames, Class<?>[] noRollbackForClasses, String[] noRollbackForClassNames) {
            Builder builder = new Builder();
            builder.setIsolation(isolation);
            builder.setPropagation(propagation);
            builder.setReadOnly(readOnly);
            builder.setTimeout(timeout);
            builder.setRollbackForClasses(rollbackForClasses);
            builder.setRollbackForClassNames(rollbackForClassNames);
            builder.setNoRollbackForClasses(noRollbackForClasses);
            builder.setNoRollbackForClassNames(noRollbackForClassNames);
            return builder.build();
        }

        public static TransactionConfig create(Propagation propagation, Class<?>[] rollbackForClasses, Class<?> ... noRollbackForClasses) {
            return Factory.create(Isolation.PORTAL, propagation, false, -1, rollbackForClasses, new String[0], noRollbackForClasses, new String[0]);
        }
    }

    public static class Builder {
        private static final Class<?>[] _emptyClassArray = new Class[0];
        private Isolation _isolation = Isolation.DEFAULT;
        private Class<?>[] _noRollbackForClasses = _emptyClassArray;
        private String[] _noRollbackForClassNames = StringPool.EMPTY_ARRAY;
        private Propagation _propagation = Propagation.REQUIRED;
        private boolean _readOnly;
        private Class<?>[] _rollbackForClasses = _emptyClassArray;
        private String[] _rollbackForClassNames = StringPool.EMPTY_ARRAY;
        private int _timeout = -1;

        public TransactionConfig build() {
            return new TransactionConfig(this);
        }

        public Builder setIsolation(Isolation isolation) {
            this._isolation = isolation;
            return this;
        }

        public Builder setNoRollbackForClasses(Class<?> ... noRollbackForClasses) {
            this._noRollbackForClasses = noRollbackForClasses;
            return this;
        }

        public Builder setNoRollbackForClassNames(String ... noRollbackForClassNames) {
            this._noRollbackForClassNames = noRollbackForClassNames;
            return this;
        }

        public Builder setPropagation(Propagation propagation) {
            this._propagation = propagation;
            return this;
        }

        public Builder setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
            return this;
        }

        public Builder setRollbackForClasses(Class<?> ... rollbackForClasses) {
            this._rollbackForClasses = rollbackForClasses;
            return this;
        }

        public Builder setRollbackForClassNames(String ... rollbackForClassNames) {
            this._rollbackForClassNames = rollbackForClassNames;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this._timeout = timeout;
            return this;
        }
    }
}

