/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.systemevent;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Stack;

public class SystemEventHierarchyEntryThreadLocal {
    private static final ThreadLocal<Stack<SystemEventHierarchyEntry>> _systemEventHierarchyEntries = new AutoResetThreadLocal(SystemEventHierarchyEntryThreadLocal.class + "._systemEventHierarchyEntries", new Stack());

    public static void clear() {
        Stack<SystemEventHierarchyEntry> systemEventHierarchyEntries = _systemEventHierarchyEntries.get();
        systemEventHierarchyEntries.clear();
    }

    public static SystemEventHierarchyEntry peek() {
        Stack<SystemEventHierarchyEntry> systemEventHierarchyEntries = _systemEventHierarchyEntries.get();
        if (systemEventHierarchyEntries.isEmpty()) {
            return null;
        }
        return systemEventHierarchyEntries.peek();
    }

    public static SystemEventHierarchyEntry pop() {
        return SystemEventHierarchyEntryThreadLocal.pop(-1L, -1L);
    }

    public static SystemEventHierarchyEntry pop(Class<?> clazz) {
        return SystemEventHierarchyEntryThreadLocal.pop(PortalUtil.getClassNameId(clazz), 0L);
    }

    public static SystemEventHierarchyEntry pop(Class<?> clazz, long classPK) {
        return SystemEventHierarchyEntryThreadLocal.pop(PortalUtil.getClassNameId(clazz), classPK);
    }

    public static SystemEventHierarchyEntry pop(long classNameId, long classPK) {
        Stack<SystemEventHierarchyEntry> systemEventHierarchyEntries = _systemEventHierarchyEntries.get();
        if (systemEventHierarchyEntries.isEmpty()) {
            return null;
        }
        SystemEventHierarchyEntry systemEventHierarchyEntry = systemEventHierarchyEntries.peek();
        if (classNameId < 0L && classPK < 0L || systemEventHierarchyEntry.hasTypedModel(classNameId, classPK)) {
            return systemEventHierarchyEntries.pop();
        }
        return null;
    }

    public static SystemEventHierarchyEntry pop(String className) {
        return SystemEventHierarchyEntryThreadLocal.pop(PortalUtil.getClassNameId(className), 0L);
    }

    public static SystemEventHierarchyEntry pop(String className, long classPK) {
        return SystemEventHierarchyEntryThreadLocal.pop(PortalUtil.getClassNameId(className), classPK);
    }

    public static SystemEventHierarchyEntry push() {
        return SystemEventHierarchyEntryThreadLocal.push(1);
    }

    public static SystemEventHierarchyEntry push(Class<?> clazz) {
        return SystemEventHierarchyEntryThreadLocal.push(PortalUtil.getClassNameId(clazz), 0L, 1);
    }

    public static SystemEventHierarchyEntry push(Class<?> clazz, long classPK) {
        return SystemEventHierarchyEntryThreadLocal.push(PortalUtil.getClassNameId(clazz), classPK, 1);
    }

    public static SystemEventHierarchyEntry push(Class<?> clazz, long classPK, int action) {
        return SystemEventHierarchyEntryThreadLocal.push(PortalUtil.getClassNameId(clazz), classPK, action);
    }

    public static SystemEventHierarchyEntry push(int action) {
        return SystemEventHierarchyEntryThreadLocal.push(0L, 0L, action);
    }

    public static SystemEventHierarchyEntry push(long classNameId, long classPK, int action) {
        long parentSystemEventId = 0L;
        long systemEventSetKey = 0L;
        Stack<SystemEventHierarchyEntry> systemEventHierarchyEntries = _systemEventHierarchyEntries.get();
        SystemEventHierarchyEntry parentSystemEventHierarchyEntry = null;
        if (!systemEventHierarchyEntries.isEmpty()) {
            parentSystemEventHierarchyEntry = systemEventHierarchyEntries.peek();
        }
        if (parentSystemEventHierarchyEntry == null) {
            systemEventSetKey = CounterLocalServiceUtil.increment();
        } else {
            if (parentSystemEventHierarchyEntry.getAction() == 1) {
                return null;
            }
            parentSystemEventId = parentSystemEventHierarchyEntry.getSystemEventId();
            systemEventSetKey = parentSystemEventHierarchyEntry.getSystemEventSetKey();
        }
        SystemEventHierarchyEntry systemEventHierarchyEntry = new SystemEventHierarchyEntry(CounterLocalServiceUtil.increment(), classNameId, classPK, parentSystemEventId, systemEventSetKey, action);
        return systemEventHierarchyEntries.push(systemEventHierarchyEntry);
    }

    public static SystemEventHierarchyEntry push(String className) {
        return SystemEventHierarchyEntryThreadLocal.push(className, 0L, 1);
    }

    public static SystemEventHierarchyEntry push(String className, long classPK, int action) {
        return SystemEventHierarchyEntryThreadLocal.push(PortalUtil.getClassNameId(className), classPK, action);
    }
}

