/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.systemevent;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.PortalUtil;

public class SystemEventHierarchyEntry {
    private final int _action;
    private long _classNameId;
    private long _classPK;
    private JSONObject _extraDataJSONObject;
    private final long _parentSystemEventId;
    private final long _systemEventId;
    private final long _systemEventSetKey;
    private String _uuid;

    public SystemEventHierarchyEntry(long systemEventId, long classNameId, long classPK, long parentSystemEventId, long systemEventSetKey, int action) {
        this._systemEventId = systemEventId;
        this._classNameId = classNameId;
        this._classPK = classPK;
        this._parentSystemEventId = parentSystemEventId;
        this._systemEventSetKey = systemEventSetKey;
        this._action = action;
    }

    public int getAction() {
        return this._action;
    }

    public String getClassName() {
        return PortalUtil.getClassName(this._classNameId);
    }

    public long getClassNameId() {
        return this._classNameId;
    }

    public String getExtraData() {
        if (this._extraDataJSONObject == null) {
            return "";
        }
        return this._extraDataJSONObject.toString();
    }

    public long getParentSystemEventId() {
        return this._parentSystemEventId;
    }

    public long getSystemEventId() {
        return this._systemEventId;
    }

    public long getSystemEventSetKey() {
        return this._systemEventSetKey;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean hasTypedModel(long classNameId, long classPK) {
        return this._classNameId == classNameId && this._classPK == classPK;
    }

    public boolean hasTypedModel(String className, long classPK) {
        long classNameId = PortalUtil.getClassNameId(className);
        return this.hasTypedModel(classNameId, classPK);
    }

    public void setClassName(String className) {
        this._classNameId = PortalUtil.getClassNameId(className);
    }

    public void setClassNameId(long classNameId) {
        this._classNameId = classNameId;
    }

    public void setExtraDataValue(String key, String value) {
        if (this._extraDataJSONObject == null) {
            this._extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        }
        this._extraDataJSONObject.put(key, value);
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }
}

