/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

public abstract class BaseTransactionalMVCActionCommand
implements MVCActionCommand {
    private static final TransactionConfig _transactionConfig;

    @Override
    public boolean processAction(final ActionRequest actionRequest, final ActionResponse actionResponse) throws PortletException {
        try {
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BaseTransactionalMVCActionCommand.this.doTransactionalCommand(actionRequest, actionResponse);
                    return SessionErrors.isEmpty((PortletRequest)actionRequest);
                }
            };
            return TransactionInvokerUtil.invoke(_transactionConfig, callable);
        }
        catch (Throwable t) {
            if (t instanceof PortletException) {
                throw (PortletException)t;
            }
            throw new PortletException(t);
        }
    }

    protected abstract void doTransactionalCommand(ActionRequest var1, ActionResponse var2) throws Exception;

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.REQUIRES_NEW);
        builder.setRollbackForClasses(Exception.class);
        _transactionConfig = builder.build();
    }
}

