/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sites.kernel.util.SitesUtil;

public abstract class BasePortletLayoutFinder
implements PortletLayoutFinder {
    @Override
    public PortletLayoutFinder.Result find(ThemeDisplay themeDisplay, long groupId) throws PortalException {
        Object[] plidAndPortletId;
        String[] portletIds = this.getPortletIds();
        if (themeDisplay.getPlid() != 0L && groupId == themeDisplay.getScopeGroupId()) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout(themeDisplay.getPlid());
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                for (String portletId : portletIds) {
                    if (!layoutTypePortlet.hasPortletId(portletId, false) || !LayoutPermissionUtil.contains(themeDisplay.getPermissionChecker(), layout, "VIEW")) continue;
                    portletId = this.getPortletId(layoutTypePortlet, portletId);
                    return new ResultImpl(themeDisplay.getPlid(), portletId);
                }
            }
            catch (NoSuchLayoutException nsle) {
                // empty catch block
            }
        }
        if ((plidAndPortletId = this.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), groupId, portletIds)) == null && SitesUtil.isUserGroupLayoutSetViewable(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup())) {
            plidAndPortletId = this.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletIds);
        }
        if (plidAndPortletId != null) {
            return new ResultImpl((Long)plidAndPortletId[0], (String)plidAndPortletId[1]);
        }
        StringBundler sb = new StringBundler(portletIds.length * 2 + 5);
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", plid=");
        sb.append(themeDisplay.getPlid());
        for (String portletId : portletIds) {
            sb.append(", portletId=");
            sb.append(portletId);
        }
        sb.append("}");
        throw new NoSuchLayoutException(sb.toString());
    }

    protected Object[] fetchPlidAndPortletId(PermissionChecker permissionChecker, long groupId, String[] portletIds) throws PortalException {
        for (String portletId : portletIds) {
            Layout layout;
            long plid = PortalUtil.getPlidFromPortletId(groupId, portletId);
            if (plid == 0L || !LayoutPermissionUtil.contains(permissionChecker, layout = LayoutLocalServiceUtil.getLayout(plid), "VIEW")) continue;
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            portletId = this.getPortletId(layoutTypePortlet, portletId);
            return new Object[]{plid, portletId};
        }
        return null;
    }

    protected String getPortletId(LayoutTypePortlet layoutTypePortlet, String portletId) {
        for (String curPortletId : layoutTypePortlet.getPortletIds()) {
            String curRootPortletId = PortletConstants.getRootPortletId(curPortletId);
            if (!portletId.equals(curRootPortletId)) continue;
            return curPortletId;
        }
        return portletId;
    }

    protected abstract String[] getPortletIds();

    protected class ResultImpl
    implements PortletLayoutFinder.Result {
        private final long _plid;
        private final String _portletId;

        public ResultImpl(long plid, String portletId) {
            this._plid = plid;
            this._portletId = portletId;
        }

        @Override
        public long getPlid() {
            return this._plid;
        }

        @Override
        public String getPortletId() {
            return this._portletId;
        }
    }
}

