/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.sender;

import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;

public class SingleDestinationMessageSenderFactoryUtil {
    private static final SingleDestinationMessageSenderFactoryUtil _instance = new SingleDestinationMessageSenderFactoryUtil();
    private final ServiceTracker<SingleDestinationMessageSenderFactory, SingleDestinationMessageSenderFactory> _serviceTracker;

    public static SingleDestinationMessageSender createSingleDestinationMessageSender(String destinationName) {
        return _instance.getSingleDestinationMessageSenderFactory().createSingleDestinationMessageSender(destinationName);
    }

    public static SingleDestinationSynchronousMessageSender createSingleDestinationSynchronousMessageSender(String destinationName, SynchronousMessageSender.Mode mode) {
        return _instance.getSingleDestinationMessageSenderFactory().createSingleDestinationSynchronousMessageSender(destinationName, mode);
    }

    public static int getModeCount() {
        return _instance.getSingleDestinationMessageSenderFactory().getModesCount();
    }

    public static SynchronousMessageSender getSynchronousMessageSender(SynchronousMessageSender.Mode mode) {
        return _instance.getSingleDestinationMessageSenderFactory().getSynchronousMessageSender(mode);
    }

    protected SingleDestinationMessageSenderFactory getSingleDestinationMessageSenderFactory() {
        try {
            while (this._serviceTracker.getService() == null) {
                Thread.sleep(500L);
            }
            return (SingleDestinationMessageSenderFactory)this._serviceTracker.getService();
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Unable to initialize SingleDestinationMessageSenderFactoryUtil", ie);
        }
    }

    private SingleDestinationMessageSenderFactoryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(SingleDestinationMessageSenderFactory.class);
        this._serviceTracker.open();
    }
}

