/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@ProviderType
public class ClusterNode
implements Serializable {
    private final InetAddress _bindInetAddress;
    private final String _clusterNodeId;
    private InetSocketAddress _portalInetSocketAddress;
    private String _portalProtocol;

    public ClusterNode(String clusterNodeId, InetAddress bindInetAddress) {
        if (clusterNodeId == null) {
            throw new IllegalArgumentException("Cluster node ID is null");
        }
        if (bindInetAddress == null) {
            throw new IllegalArgumentException("Bind inet address is null");
        }
        this._clusterNodeId = clusterNodeId;
        this._bindInetAddress = bindInetAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode clusterNode = (ClusterNode)obj;
        return Validator.equals(this._clusterNodeId, clusterNode._clusterNodeId) && Validator.equals(this._bindInetAddress, clusterNode._bindInetAddress) && Validator.equals(this._portalInetSocketAddress, clusterNode._portalInetSocketAddress) && Validator.equals(this._portalProtocol, clusterNode._portalProtocol);
    }

    public InetAddress getBindInetAddress() {
        return this._bindInetAddress;
    }

    public String getClusterNodeId() {
        return this._clusterNodeId;
    }

    public InetAddress getPortalInetAddress() {
        if (this._portalInetSocketAddress == null) {
            return null;
        }
        return this._portalInetSocketAddress.getAddress();
    }

    public InetSocketAddress getPortalInetSocketAddress() {
        return this._portalInetSocketAddress;
    }

    public int getPortalPort() {
        if (this._portalInetSocketAddress == null) {
            return -1;
        }
        return this._portalInetSocketAddress.getPort();
    }

    public String getPortalProtocol() {
        return this._portalProtocol;
    }

    public int hashCode() {
        int hash = HashUtil.hash(0, this._clusterNodeId);
        hash = HashUtil.hash(hash, this._bindInetAddress);
        hash = HashUtil.hash(hash, this._portalInetSocketAddress);
        hash = HashUtil.hash(hash, this._portalProtocol);
        return hash;
    }

    public void setPortalInetSocketAddress(InetSocketAddress portalInetSocketAddress) {
        this._portalInetSocketAddress = portalInetSocketAddress;
    }

    public void setPortalProtocol(String portalProtocol) {
        this._portalProtocol = portalProtocol;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{bindInetAddress=");
        sb.append(this._bindInetAddress);
        sb.append(", clusterNodeId=");
        sb.append(this._clusterNodeId);
        sb.append(", portalInetSocketAddress=");
        sb.append(this._portalInetSocketAddress);
        sb.append(", portalProtocol=");
        sb.append(this._portalProtocol);
        sb.append("}");
        return sb.toString();
    }
}

