/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.transactional;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.SkipReplicationThreadLocal;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalPortalCacheHelper {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new TransactionLifecycleListener(){

        @Override
        public void committed(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            if (!TransactionalPortalCacheHelper._isTransactionalCacheEnabled()) {
                return;
            }
            Propagation propagation = transactionAttribute.getPropagation();
            if (propagation.value() >= 4) {
                List backupPortalCacheMaps = (List)_backupPortalCacheMapsThreadLocal.get();
                _portalCacheMapsThreadLocal.set(backupPortalCacheMaps.remove(backupPortalCacheMaps.size() - 1));
            } else if (transactionStatus.isNewTransaction()) {
                TransactionalPortalCacheHelper.commit();
            }
        }

        @Override
        public void created(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            if (!TransactionalPortalCacheHelper._isTransactionalCacheEnabled()) {
                return;
            }
            Propagation propagation = transactionAttribute.getPropagation();
            if (propagation.value() >= 4) {
                List backupPortalCacheMaps = (List)_backupPortalCacheMapsThreadLocal.get();
                backupPortalCacheMaps.add(_portalCacheMapsThreadLocal.get());
                _portalCacheMapsThreadLocal.remove();
            } else if (transactionStatus.isNewTransaction()) {
                TransactionalPortalCacheHelper.begin();
            }
        }

        @Override
        public void rollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            if (!TransactionalPortalCacheHelper._isTransactionalCacheEnabled()) {
                return;
            }
            Propagation propagation = transactionAttribute.getPropagation();
            if (propagation.value() >= 4) {
                List backupPortalCacheMaps = (List)_backupPortalCacheMapsThreadLocal.get();
                _portalCacheMapsThreadLocal.set(backupPortalCacheMaps.remove(backupPortalCacheMaps.size() - 1));
            } else if (transactionStatus.isNewTransaction()) {
                TransactionalPortalCacheHelper.rollback();
                EntityCacheUtil.clearLocalCache();
                FinderCacheUtil.clearLocalCache();
            }
        }
    };
    private static final Serializable _NULL_HOLDER = "NULL_HOLDER";
    private static final ValueEntry _NULL_HOLDER_VALUE_ENTRY = new ValueEntry(_NULL_HOLDER, 0, false);
    private static final ThreadLocal<List<List<PortalCacheMap>>> _backupPortalCacheMapsThreadLocal = new InitialThreadLocal(TransactionalPortalCacheHelper.class.getName() + "._backupPortalCacheMapsThreadLocal", new ArrayList());
    private static final ThreadLocal<List<PortalCacheMap>> _portalCacheMapsThreadLocal = new InitialThreadLocal(TransactionalPortalCacheHelper.class.getName() + "._portalCacheMapsThreadLocal", new ArrayList());
    private static volatile Boolean _transactionalCacheEnabled;

    public static void begin() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        portalCacheMaps.add(new PortalCacheMap());
    }

    public static void commit() {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        for (Map.Entry portalCacheMapEntry : portalCacheMap.entrySet()) {
            PortalCache portalCache = (PortalCache)portalCacheMapEntry.getKey();
            UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMapEntry.getValue();
            uncommittedBuffer.commitTo(portalCache);
        }
        portalCacheMap.clear();
    }

    public static <K extends Serializable, V> V get(PortalCache<K, V> portalCache, K key) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            return null;
        }
        ValueEntry valueEntry = uncommittedBuffer.get(key);
        if (valueEntry == null) {
            return null;
        }
        return (V)valueEntry._value;
    }

    public static Serializable getNullHolder() {
        return _NULL_HOLDER;
    }

    public static boolean isEnabled() {
        if (!TransactionalPortalCacheHelper._isTransactionalCacheEnabled()) {
            return false;
        }
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return !portalCacheMaps.isEmpty();
    }

    public static <K extends Serializable, V> void put(PortalCache<K, V> portalCache, K key, V value, int ttl) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.put(key, new ValueEntry(value, ttl, SkipReplicationThreadLocal.isEnabled()));
    }

    public static <K extends Serializable, V> void removeAll(PortalCache<K, V> portalCache) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.removeAll(SkipReplicationThreadLocal.isEnabled());
    }

    public static void rollback() {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        portalCacheMap.clear();
    }

    private static boolean _isTransactionalCacheEnabled() {
        if (_transactionalCacheEnabled == null) {
            _transactionalCacheEnabled = GetterUtil.getBoolean(PropsUtil.get("transactional.cache.enable"));
        }
        return _transactionalCacheEnabled;
    }

    private static PortalCacheMap _peekPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.get(portalCacheMaps.size() - 1);
    }

    private static PortalCacheMap _popPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.remove(portalCacheMaps.size() - 1);
    }

    private static class ValueEntry {
        private boolean _skipReplicator;
        private final int _ttl;
        private final Object _value;

        public ValueEntry(Object value, int ttl, boolean skipReplicator) {
            this._value = value;
            this._ttl = ttl;
            this._skipReplicator = skipReplicator;
        }

        public void commitTo(PortalCache<Serializable, Object> portalCache, Serializable key) {
            if (this._value == _NULL_HOLDER) {
                if (this._skipReplicator) {
                    PortalCacheHelperUtil.removeWithoutReplicator(portalCache, key);
                } else {
                    portalCache.remove(key);
                }
            } else if (this._skipReplicator) {
                PortalCacheHelperUtil.putWithoutReplicator(portalCache, key, this._value, this._ttl);
            } else {
                portalCache.put(key, this._value, this._ttl);
            }
        }

        public void merge(ValueEntry valueEntry) {
            if (!this._skipReplicator) {
                valueEntry._skipReplicator = false;
            }
        }
    }

    private static class UncommittedBuffer {
        private boolean _removeAll;
        private boolean _skipReplicator = true;
        private final Map<Serializable, ValueEntry> _uncommittedMap = new HashMap<Serializable, ValueEntry>();

        private UncommittedBuffer() {
        }

        public void commitTo(PortalCache<Serializable, Object> portalCache) {
            if (this._removeAll) {
                if (this._skipReplicator) {
                    PortalCacheHelperUtil.removeAllWithoutReplicator(portalCache);
                } else {
                    portalCache.removeAll();
                }
            }
            for (Map.Entry<Serializable, ValueEntry> entry : this._uncommittedMap.entrySet()) {
                ValueEntry valueEntry = entry.getValue();
                valueEntry.commitTo(portalCache, entry.getKey());
            }
        }

        public ValueEntry get(Serializable key) {
            ValueEntry valueEntry = this._uncommittedMap.get(key);
            if (valueEntry == null && this._removeAll) {
                valueEntry = _NULL_HOLDER_VALUE_ENTRY;
            }
            return valueEntry;
        }

        public void put(Serializable key, ValueEntry valueEntry) {
            ValueEntry oldValueEntry = this._uncommittedMap.put(key, valueEntry);
            if (oldValueEntry != null) {
                oldValueEntry.merge(valueEntry);
            }
        }

        public void removeAll(boolean skipReplicator) {
            this._uncommittedMap.clear();
            this._removeAll = true;
            if (this._skipReplicator) {
                this._skipReplicator = skipReplicator;
            }
        }
    }

    protected static class PortalCacheMap
    extends HashMap<PortalCache<? extends Serializable, ?>, UncommittedBuffer> {
        protected PortalCacheMap() {
        }
    }
}

