/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.kernel;

import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocalizedValue
implements Value {
    private Locale _defaultLocale;
    private final Map<Locale, String> _values = new HashMap<Locale, String>();

    public LocalizedValue() {
        this(LocaleUtil.getDefault());
    }

    public LocalizedValue(Locale defaultLocale) {
        this.setDefaultLocale(defaultLocale);
    }

    public LocalizedValue(LocalizedValue localizedValue) {
        this._defaultLocale = localizedValue._defaultLocale;
        Map<Locale, String> values = localizedValue._values;
        for (Map.Entry<Locale, String> entry : values.entrySet()) {
            this.addString(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addString(Locale locale, String value) {
        this._values.put(locale, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocalizedValue)) {
            return false;
        }
        LocalizedValue localizedValue = (LocalizedValue)obj;
        return Validator.equals(this._defaultLocale, localizedValue._defaultLocale) && Validator.equals(this._values, localizedValue._values);
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return this._values.keySet();
    }

    @Override
    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    @Override
    public String getString(Locale locale) {
        String value = this._values.get(locale);
        if (value == null) {
            value = this._values.get(this._defaultLocale);
        }
        return value;
    }

    @Override
    public Map<Locale, String> getValues() {
        return this._values;
    }

    public int hashCode() {
        int hash = HashUtil.hash(0, this._defaultLocale);
        return HashUtil.hash(hash, this._values);
    }

    @Override
    public boolean isLocalized() {
        return true;
    }

    @Override
    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }
}

