/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.image.ImageToolImpl;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioResampler;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;

public abstract class LiferayConverter {
    protected static final int AUDIO_BIT_RATE_DEFAULT = 64000;
    protected static final int AUDIO_BIT_RATE_MAX = 500000;
    protected static final int AUDIO_SAMPLE_RATE_DEFAULT = 44100;
    protected static final int AUDIO_SAMPLE_RATE_MAX = 192000;
    protected static final int DECODE_VIDEO_THUMBNAIL = 2;
    private static final Log _log = LogFactoryUtil.getLog(LiferayConverter.class);
    private ConverterFactory.Type _converterFactoryType;
    private IConverter _videoIConverter;

    public abstract void convert() throws Exception;

    protected void cleanUp(IPacket inputIPacket, IPacket outputIPacket) {
        if (inputIPacket != null) {
            inputIPacket.delete();
        }
        if (outputIPacket != null) {
            outputIPacket.delete();
        }
    }

    protected void cleanUp(IStreamCoder[] inputIStreamCoders, IStreamCoder[] outputIStreamCoders) {
        if (inputIStreamCoders != null) {
            for (IStreamCoder iStreamCoder : inputIStreamCoders) {
                if (iStreamCoder == null) continue;
                iStreamCoder.close();
            }
        }
        if (outputIStreamCoders != null) {
            for (IStreamCoder iStreamCoder : outputIStreamCoders) {
                if (iStreamCoder == null) continue;
                iStreamCoder.close();
            }
        }
    }

    protected void cleanUp(RefCounted[] inputRefCountedArray, RefCounted[] outputRefCountedArray) {
        if (inputRefCountedArray != null) {
            for (RefCounted refCounted : inputRefCountedArray) {
                if (refCounted == null) continue;
                refCounted.delete();
            }
        }
        if (outputRefCountedArray != null) {
            for (RefCounted refCounted : outputRefCountedArray) {
                if (refCounted == null) continue;
                refCounted.delete();
            }
        }
    }

    protected int countNonKeyAfterKey(IPacket inputIPacket, Boolean keyPacketFound, int nonKeyAfterKeyCount) {
        if (inputIPacket.isKey()) {
            nonKeyAfterKeyCount = 0;
        } else if (keyPacketFound.booleanValue()) {
            ++nonKeyAfterKeyCount;
        }
        return nonKeyAfterKeyCount;
    }

    protected IAudioResampler createIAudioResampler(IStreamCoder inputIStreamCoder, IStreamCoder outputIStreamCoder) throws Exception {
        IAudioResampler iAudioResampler = null;
        IAudioSamples.Format inputSampleFormat = inputIStreamCoder.getSampleFormat();
        IAudioSamples.Format outputSampleFormat = outputIStreamCoder.getSampleFormat();
        if (inputIStreamCoder.getChannels() == outputIStreamCoder.getChannels() && inputIStreamCoder.getSampleRate() == outputIStreamCoder.getSampleRate() && inputSampleFormat.equals((Object)outputSampleFormat)) {
            return iAudioResampler;
        }
        iAudioResampler = IAudioResampler.make((int)outputIStreamCoder.getChannels(), (int)inputIStreamCoder.getChannels(), (int)outputIStreamCoder.getSampleRate(), (int)inputIStreamCoder.getSampleRate(), (IAudioSamples.Format)outputIStreamCoder.getSampleFormat(), (IAudioSamples.Format)inputIStreamCoder.getSampleFormat());
        if (iAudioResampler == null) {
            throw new RuntimeException("Audio resampling is not supported");
        }
        return iAudioResampler;
    }

    protected IVideoResampler createIVideoResampler(IStreamCoder inputIStreamCoder, IStreamCoder outputIStreamCoder, int height, int width) throws Exception {
        IVideoResampler iVideoResampler = null;
        IPixelFormat.Type inputIPixelFormatType = inputIStreamCoder.getPixelType();
        IPixelFormat.Type outputIPixelFormatType = outputIStreamCoder.getPixelType();
        if (height == inputIStreamCoder.getHeight() && width == inputIStreamCoder.getWidth() && inputIPixelFormatType.equals((Object)outputIPixelFormatType)) {
            return iVideoResampler;
        }
        iVideoResampler = IVideoResampler.make((int)width, (int)height, (IPixelFormat.Type)outputIStreamCoder.getPixelType(), (int)inputIStreamCoder.getWidth(), (int)inputIStreamCoder.getHeight(), (IPixelFormat.Type)inputIStreamCoder.getPixelType());
        if (iVideoResampler == null) {
            throw new RuntimeException("Video resampling is not supported");
        }
        return iVideoResampler;
    }

    protected void decodeAudio(IAudioResampler iAudioResampler, IAudioSamples inputIAudioSample, IAudioSamples resampledIAudioSample, IPacket inputIPacket, IPacket outputIPacket, IStreamCoder inputIStreamCoder, IStreamCoder outputIStreamCoder, IContainer outputIContainer, int currentPacketSize, int previousPacketSize, int streamIndex, long timeStampOffset) throws Exception {
        int value;
        for (int offset = 0; offset < inputIPacket.getSize(); offset += value) {
            boolean stopDecoding = false;
            value = inputIStreamCoder.decodeAudio(inputIAudioSample, inputIPacket, offset);
            if (value <= 0) {
                if (previousPacketSize == currentPacketSize && previousPacketSize != -1) {
                    throw new RuntimeException("Unable to decode audio stream " + streamIndex);
                }
                stopDecoding = true;
            }
            this.updateAudioTimeStamp(inputIAudioSample, timeStampOffset);
            IAudioSamples outputIAudioSample = this.resampleAudio(iAudioResampler, inputIAudioSample, resampledIAudioSample);
            this.encodeAudio(outputIStreamCoder, outputIPacket, outputIAudioSample, outputIContainer);
            if (!stopDecoding) continue;
            if (!_log.isDebugEnabled()) break;
            _log.debug((Object)("Stop decoding audio stream " + streamIndex));
            break;
        }
    }

    protected int decodeVideo(IVideoResampler iVideoResampler, IVideoPicture inputIVideoPicture, IVideoPicture resampledIVideoPicture, IPacket inputIPacket, IPacket outputIPacket, IStreamCoder inputIStreamCoder, IStreamCoder outputIStreamCoder, IContainer outputIContainer, File thumbnailFile, String thumbnailExtension, int thumbnailHeight, int thumbnailWidth, long timeStampOffset) throws Exception {
        int offset = 0;
        boolean stopDecoding = false;
        while (offset < inputIPacket.getSize()) {
            int value = inputIStreamCoder.decodeVideo(inputIVideoPicture, inputIPacket, offset);
            if (value <= 0) {
                return value;
            }
            this.updateVideoTimeStamp(inputIVideoPicture, timeStampOffset);
            offset += value;
            ICodec.ID iCodecID = inputIStreamCoder.getCodecID();
            if (iCodecID.equals((Object)ICodec.ID.CODEC_ID_MJPEG)) {
                stopDecoding = true;
            }
            if (!inputIVideoPicture.isComplete()) {
                if (!stopDecoding) continue;
                return 1;
            }
            if (thumbnailFile != null) {
                BufferedImage bufferedImage = null;
                if (this._converterFactoryType == null) {
                    this._converterFactoryType = ConverterFactory.findRegisteredConverter((String)"XUGGLER-BGR-24");
                }
                if (this._converterFactoryType == null) {
                    throw new UnsupportedOperationException("No converter found for XUGGLER-BGR-24");
                }
                if (this._videoIConverter == null) {
                    this._videoIConverter = ConverterFactory.createConverter((String)this._converterFactoryType.getDescriptor(), (IVideoPicture)inputIVideoPicture);
                }
                bufferedImage = this._videoIConverter.toImage(inputIVideoPicture);
                thumbnailFile.createNewFile();
                ImageTool imageTool = ImageToolImpl.getInstance();
                RenderedImage renderedImage = imageTool.scale((RenderedImage)bufferedImage, thumbnailHeight, thumbnailWidth);
                ImageIO.write(renderedImage, thumbnailExtension, new FileOutputStream(thumbnailFile));
                return 2;
            }
            if (outputIStreamCoder != null && outputIContainer != null) {
                IVideoPicture outputIVideoPicture = this.resampleVideo(iVideoResampler, inputIVideoPicture, resampledIVideoPicture);
                outputIVideoPicture.setQuality(0);
                this.encodeVideo(outputIStreamCoder, outputIVideoPicture, outputIPacket, outputIContainer);
            }
            if (!stopDecoding) continue;
            break;
        }
        return 1;
    }

    protected void encodeAudio(IStreamCoder outputIStreamCoder, IPacket outputIPacket, IAudioSamples outputIAudioSample, IContainer outputIContainer) throws Exception {
        int consumedSamplesCount = 0;
        while ((long)consumedSamplesCount < outputIAudioSample.getNumSamples()) {
            int value = outputIStreamCoder.encodeAudio(outputIPacket, outputIAudioSample, (long)consumedSamplesCount);
            if (value <= 0) {
                throw new RuntimeException("Unable to encode audio");
            }
            consumedSamplesCount += value;
            if (!outputIPacket.isComplete() || (value = outputIContainer.writePacket(outputIPacket, true)) >= 0) continue;
            throw new RuntimeException("Unable to write audio packet");
        }
    }

    protected void encodeVideo(IStreamCoder outputIStreamCoder, IVideoPicture outputIVideoPicture, IPacket outputIPacket, IContainer outputIContainer) throws Exception {
        int value = outputIStreamCoder.encodeVideo(outputIPacket, outputIVideoPicture, 0);
        if (value < 0) {
            throw new RuntimeException("Unable to encode video");
        }
        if (outputIPacket.isComplete() && (value = outputIContainer.writePacket(outputIPacket, true)) < 0) {
            throw new RuntimeException("Unable to write video packet");
        }
    }

    protected void flush(IStreamCoder outputIStreamCoder, IContainer outputIContainer, IPacket iPacket) {
        if (outputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
            outputIStreamCoder.encodeAudio(iPacket, null, 0L);
        } else {
            outputIStreamCoder.encodeVideo(iPacket, null, 0);
        }
        if (iPacket.isComplete()) {
            outputIContainer.writePacket(iPacket, true);
        }
    }

    protected void flush(IStreamCoder[] outputIStreamCoders, IContainer outputIContainer) {
        for (IStreamCoder outputIStreamCoder : outputIStreamCoders) {
            if (outputIStreamCoder == null) continue;
            IPacket iPacket = IPacket.make();
            this.flush(outputIStreamCoder, outputIContainer, iPacket);
            while (iPacket.isComplete()) {
                this.flush(outputIStreamCoder, outputIContainer, iPacket);
            }
        }
    }

    protected int getAudioBitRate(ICodec outputICodec, int originalBitRate) {
        return this.getCodecBitRate(outputICodec, this.getProperty(originalBitRate, 64000, 500000));
    }

    protected int getAudioEncodingChannels(IContainer outputIContainer, int channels) {
        IContainerFormat iContainerFormat = outputIContainer.getContainerFormat();
        String outputFormat = iContainerFormat.getOutputFormatShortName();
        if (outputFormat.equals("ogg")) {
            return 2;
        }
        if (channels == 0 || channels > 2) {
            channels = 2;
        }
        return channels;
    }

    protected ICodec getAudioEncodingICodec(IContainer outputIContainer) {
        IContainerFormat iContainerFormat = outputIContainer.getContainerFormat();
        String outputFormat = iContainerFormat.getOutputFormatShortName();
        if (outputFormat.equals("ogg")) {
            return ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_VORBIS);
        }
        return null;
    }

    protected IAudioSamples.Format getAudioSampleFormat(ICodec outputICodec, IAudioSamples.Format originalSampleFormat) {
        IAudioSamples.Format sampleFormat = null;
        List supportedSampleFormats = outputICodec.getSupportedAudioSampleFormats();
        Iterator i$ = supportedSampleFormats.iterator();
        while (i$.hasNext()) {
            IAudioSamples.Format supportedSampleFormat;
            sampleFormat = supportedSampleFormat = (IAudioSamples.Format)i$.next();
            if (supportedSampleFormat != originalSampleFormat) continue;
            break;
        }
        return sampleFormat;
    }

    protected int getAudioSampleRate() {
        return 44100;
    }

    protected int getCodecBitRate(ICodec outputICodec, int originalBitRate) {
        ICodec.ID iCodecID;
        if (originalBitRate == 0 || originalBitRate > 500000) {
            originalBitRate = 64000;
        }
        if ((iCodecID = outputICodec.getID()).equals((Object)ICodec.ID.CODEC_ID_VORBIS) && originalBitRate < 64000) {
            return 64000;
        }
        return originalBitRate;
    }

    protected abstract IContainer getInputIContainer();

    protected int getProperty(int originalValue, int defaultValue, int maxValue) {
        if (originalValue <= 0) {
            return defaultValue;
        }
        if (originalValue > maxValue) {
            return maxValue;
        }
        return originalValue;
    }

    protected int getProperty(Properties properties, String propertyName, String prettyPropertyName, String container, int defaultValue, int maxValue) {
        int property = GetterUtil.getInteger((String)properties.getProperty(propertyName + "[" + container + "]"), (int)defaultValue);
        if (property > maxValue) {
            property = maxValue;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Default " + prettyPropertyName + " for " + container + " configured to " + property));
        }
        return property;
    }

    protected long getSeekTimeStamp(int percentage) throws Exception {
        IContainer inputIContainer = this.getInputIContainer();
        long seekTimeStamp = -1L;
        long videoSeconds = inputIContainer.getDuration() / 1000000L;
        long seekSeconds = videoSeconds * (long)percentage / 100L;
        for (int i = 0; i < inputIContainer.getNumStreams(); ++i) {
            IStream inputIStream = inputIContainer.getStream((long)i);
            IStreamCoder inputIStreamCoder = inputIStream.getStreamCoder();
            if (inputIStreamCoder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            IRational iRational = inputIStream.getTimeBase();
            long timeStampOffset = (long)(iRational.getDenominator() / iRational.getNumerator()) * seekSeconds;
            seekTimeStamp = inputIContainer.getStartTime() + timeStampOffset;
            break;
        }
        return seekTimeStamp;
    }

    protected long getStreamTimeStampOffset(IStream iStream) {
        long timeStampOffset = 0L;
        if (iStream.getStartTime() != Global.NO_PTS && iStream.getStartTime() > 0L && iStream.getTimeBase() != null) {
            IRational iRational = IRational.make((int)1, (int)((int)Global.DEFAULT_PTS_PER_SECOND));
            timeStampOffset = iRational.rescale(iStream.getStartTime(), iStream.getTimeBase());
        }
        return timeStampOffset;
    }

    protected boolean isKeyPacketFound(IPacket inputIPacket, boolean keyPacketFound) {
        if (inputIPacket.isKey() && !keyPacketFound) {
            return true;
        }
        return keyPacketFound;
    }

    protected boolean isStartDecoding(IPacket inputIPacket, IStreamCoder inputIStreamCoder, boolean keyPacketFound, int nonKeyAfterKeyCount, boolean onlyDecodeKeyPackets) {
        if (onlyDecodeKeyPackets && !inputIPacket.isKey()) {
            return false;
        }
        ICodec.ID iCodecID = inputIStreamCoder.getCodecID();
        if (iCodecID.equals((Object)ICodec.ID.CODEC_ID_MJPEG)) {
            return true;
        }
        if (iCodecID.equals((Object)ICodec.ID.CODEC_ID_MPEG2VIDEO) || iCodecID.equals((Object)ICodec.ID.CODEC_ID_THEORA)) {
            return nonKeyAfterKeyCount != 1;
        }
        return keyPacketFound;
    }

    protected void openContainer(IContainer iContainer, String url, boolean writeContainer) throws Exception {
        int value = 0;
        value = writeContainer ? iContainer.open(url, IContainer.Type.WRITE, null) : iContainer.open(url, IContainer.Type.READ, null);
        if (value < 0) {
            if (writeContainer) {
                throw new RuntimeException("Unable to open output URL");
            }
            throw new RuntimeException("Unable to open input URL");
        }
    }

    protected void openStreamCoder(IStreamCoder iStreamCoder) throws Exception {
        if (iStreamCoder != null && iStreamCoder.getCodecType() != ICodec.Type.CODEC_TYPE_UNKNOWN) {
            int result = iStreamCoder.setStandardsCompliance(IStreamCoder.CodecStandardsCompliance.COMPLIANCE_EXPERIMENTAL);
            if (result < 0) {
                throw new RuntimeException("Unable to set compliance mode to experimental");
            }
            if (iStreamCoder.open(null, null) < 0) {
                throw new RuntimeException("Unable to open coder");
            }
        }
    }

    protected void prepareAudio(IAudioResampler[] iAudioResamplers, IAudioSamples[] inputIAudioSamples, IAudioSamples[] outputIAudioSamples, IStreamCoder inputIStreamCoder, IStreamCoder[] outputIStreamCoders, IContainer outputIContainer, IStream[] outputIStreams, ICodec.Type inputICodecType, String outputURL, int index) throws Exception {
        IStreamCoder outputIStreamCoder;
        IStream outputIStream;
        ICodec iCodec = this.getAudioEncodingICodec(outputIContainer);
        if (iCodec == null) {
            iCodec = ICodec.guessEncodingCodec(null, null, (String)outputURL, null, (ICodec.Type)inputICodecType);
        }
        if (iCodec == null) {
            throw new RuntimeException("Unable to determine " + inputICodecType + " encoder for " + outputURL);
        }
        outputIStreams[index] = outputIStream = outputIContainer.addNewStream(iCodec);
        outputIStreamCoders[index] = outputIStreamCoder = outputIStream.getStreamCoder();
        int bitRate = inputIStreamCoder.getBitRate();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Original audio bitrate " + bitRate));
        }
        bitRate = this.getAudioBitRate(iCodec, bitRate);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modified audio bitrate " + bitRate));
        }
        outputIStreamCoder.setBitRate(bitRate);
        int channels = this.getAudioEncodingChannels(outputIContainer, inputIStreamCoder.getChannels());
        outputIStreamCoder.setChannels(channels);
        outputIStreamCoder.setGlobalQuality(0);
        IAudioSamples.Format sampleFormat = inputIStreamCoder.getSampleFormat();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Original audio sample format " + sampleFormat.toString()));
        }
        sampleFormat = this.getAudioSampleFormat(iCodec, sampleFormat);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modified audio sample format " + sampleFormat.toString()));
        }
        outputIStreamCoder.setSampleFormat(sampleFormat);
        outputIStreamCoder.setSampleRate(this.getAudioSampleRate());
        iAudioResamplers[index] = this.createIAudioResampler(inputIStreamCoder, outputIStreamCoder);
        inputIAudioSamples[index] = IAudioSamples.make((long)1024L, (long)inputIStreamCoder.getChannels(), (IAudioSamples.Format)inputIStreamCoder.getSampleFormat());
        outputIAudioSamples[index] = IAudioSamples.make((long)1024L, (long)outputIStreamCoder.getChannels(), (IAudioSamples.Format)outputIStreamCoder.getSampleFormat());
    }

    protected IAudioSamples resampleAudio(IAudioResampler iAudioResampler, IAudioSamples inputIAudioSample, IAudioSamples resampledIAudioSample) throws Exception {
        if (iAudioResampler == null || inputIAudioSample.getNumSamples() <= 0L) {
            return inputIAudioSample;
        }
        iAudioResampler.resample(resampledIAudioSample, inputIAudioSample, inputIAudioSample.getNumSamples());
        return resampledIAudioSample;
    }

    protected IVideoPicture resampleVideo(IVideoResampler iVideoResampler, IVideoPicture inputIVideoPicture, IVideoPicture resampledIVideoPicture) throws Exception {
        if (iVideoResampler == null) {
            return inputIVideoPicture;
        }
        if (iVideoResampler.resample(resampledIVideoPicture, inputIVideoPicture) < 0) {
            throw new RuntimeException("Unable to resample video");
        }
        return resampledIVideoPicture;
    }

    protected void rewind() throws Exception {
        IContainer inputIContainer = this.getInputIContainer();
        if (inputIContainer == null) {
            return;
        }
        int value = 0;
        for (int i = 0; i < inputIContainer.getNumStreams(); ++i) {
            IStream inputIStream = inputIContainer.getStream((long)i);
            IStreamCoder inputIStreamCoder = inputIStream.getStreamCoder();
            if (inputIStreamCoder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            value = this.rewind(i);
            if (value >= 0) break;
            throw new RuntimeException("Error while seeking file");
        }
    }

    protected int rewind(int index) throws Exception {
        IContainer inputIContainer = this.getInputIContainer();
        if (inputIContainer == null) {
            return -1;
        }
        int value = inputIContainer.seekKeyFrame(index, -1L, 0);
        if (value < 0) {
            throw new RuntimeException("Error while seeking file");
        }
        return value;
    }

    protected int seek(int index, long timeStamp) throws Exception {
        IContainer inputIContainer = this.getInputIContainer();
        if (inputIContainer == null) {
            return -1;
        }
        int value = inputIContainer.seekKeyFrame(index, timeStamp, 0);
        if (value < 0) {
            throw new RuntimeException("Error while seeking file");
        }
        return value;
    }

    protected long seek(long timeStamp) throws Exception {
        IContainer inputIContainer = this.getInputIContainer();
        if (inputIContainer == null) {
            return -1L;
        }
        int value = 0;
        for (int i = 0; i < inputIContainer.getNumStreams(); ++i) {
            IStream inputIStream = inputIContainer.getStream((long)i);
            IStreamCoder inputIStreamCoder = inputIStream.getStreamCoder();
            if (inputIStreamCoder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            value = this.seek(i, timeStamp);
            if (value >= 0) break;
            throw new RuntimeException("Error while seeking file");
        }
        return value;
    }

    protected void updateAudioTimeStamp(IAudioSamples inputAudioSample, long timeStampOffset) {
        if (inputAudioSample.getTimeStamp() != Global.NO_PTS) {
            inputAudioSample.setTimeStamp(inputAudioSample.getTimeStamp() - timeStampOffset);
        }
    }

    protected void updateVideoTimeStamp(IVideoPicture inputIVideoPicture, long timeStampOffset) {
        if (inputIVideoPicture.getTimeStamp() != Global.NO_PTS) {
            inputIVideoPicture.setTimeStamp(inputIVideoPicture.getTimeStamp() - timeStampOffset);
        }
    }
}

