/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.FileShortcutPermissionException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileShortcutServiceImpl
extends DLFileShortcutServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long groupId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_SHORTCUT");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException((Throwable)pe);
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), groupId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "DELETE");
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "VIEW");
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException((Throwable)pe);
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), oldToFileEntryId, "VIEW");
            DLFileEntryPermission.check(this.getPermissionChecker(), newToFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException((Throwable)pe);
        }
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }
}

