/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import java.util.List;

public class BaseAssetEntryValidator
implements AssetEntryValidator {
    @Override
    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        Group companyGroup;
        List vocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)groupId, (boolean)false);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!group.isCompany() && (companyGroup = GroupLocalServiceUtil.fetchCompanyGroup((long)group.getCompanyId())) != null) {
            vocabularies = ListUtil.copy((List)vocabularies);
            vocabularies.addAll(AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)companyGroup.getGroupId()));
        }
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)className);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.validate(classNameId, classTypePK, categoryIds, vocabulary);
        }
    }

    protected boolean isAssetCategorizable(long classNameId) {
        String className = PortalUtil.getClassName((long)classNameId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        return assetRendererFactory != null && assetRendererFactory.isCategorizable();
    }

    protected void validate(long classNameId, long classTypePK, long[] categoryIds, AssetVocabulary vocabulary) throws PortalException {
        if (!vocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK)) {
            return;
        }
        if (!this.isAssetCategorizable(classNameId)) {
            return;
        }
        if (vocabulary.isMissingRequiredCategory(classNameId, classTypePK, categoryIds)) {
            throw new AssetCategoryException(vocabulary, 1);
        }
        if (!vocabulary.isMultiValued() && vocabulary.hasMoreThanOneCategorySelected(categoryIds)) {
            throw new AssetCategoryException(vocabulary, 2);
        }
    }
}

