/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.exception.EntryContentException;
import com.liferay.announcements.kernel.exception.EntryDisplayDateException;
import com.liferay.announcements.kernel.exception.EntryExpirationDateException;
import com.liferay.announcements.kernel.exception.EntryTitleException;
import com.liferay.announcements.kernel.exception.EntryURLException;
import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryLocalServiceBaseImpl;
import com.liferay.util.ContentUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class AnnouncementsEntryLocalServiceImpl
extends AnnouncementsEntryLocalServiceBaseImpl {
    private static final long _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL = (long)PropsValues.ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL * 60000L;
    private static final Log _log = LogFactoryUtil.getLog(AnnouncementsEntryLocalServiceImpl.class);
    private Date _previousCheckDate;

    public AnnouncementsEntry addEntry(long userId, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), EntryExpirationDateException.class);
        this.validate(title, content, url, expirationDate);
        long entryId = this.counterLocalService.increment();
        AnnouncementsEntry entry = this.announcementsEntryPersistence.create(entryId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setClassNameId(classNameId);
        entry.setClassPK(classPK);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        entry.setAlert(alert);
        this.announcementsEntryPersistence.update((BaseModel)entry);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), false, false, false);
        return entry;
    }

    public void checkEntries() throws PortalException {
        Date now = new Date();
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(now.getTime() - _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL);
        }
        List entries = this.announcementsEntryFinder.findByDisplayDate(now, this._previousCheckDate);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries"));
        }
        for (AnnouncementsEntry entry : entries) {
            this.notifyUsers(entry);
        }
        this._previousCheckDate = now;
    }

    public void deleteEntry(AnnouncementsEntry entry) throws PortalException {
        this.announcementsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), AnnouncementsEntry.class.getName(), 4, entry.getEntryId());
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException {
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue, int start, int end) {
        return this.getEntries(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        return this.announcementsEntryFinder.findByScopes(userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long classNameId, long classPK, boolean alert, int start, int end) {
        return this.announcementsEntryPersistence.findByC_C_A(classNameId, classPK, alert, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        return this.announcementsEntryFinder.findByScope(userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        return this.announcementsEntryFinder.countByScopes(userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public int getEntriesCount(long classNameId, long classPK, boolean alert) {
        return this.announcementsEntryPersistence.countByC_C_A(classNameId, classPK, alert);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, classNameId, classPKs, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        return this.announcementsEntryFinder.countByScope(userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public AnnouncementsEntry getEntry(long entryId) throws PortalException {
        return this.announcementsEntryPersistence.findByPrimaryKey(entryId);
    }

    public List<AnnouncementsEntry> getUserEntries(long userId, int start, int end) {
        return this.announcementsEntryPersistence.findByUserId(userId, start, end);
    }

    public int getUserEntriesCount(long userId) {
        return this.announcementsEntryPersistence.countByUserId(userId);
    }

    public AnnouncementsEntry updateEntry(long userId, long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), EntryExpirationDateException.class);
        this.validate(title, content, url, expirationDate);
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        this.announcementsEntryPersistence.update((BaseModel)entry);
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
        return entry;
    }

    protected void notifyUsers(AnnouncementsEntry entry) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(entry.getCompanyId());
        String className = entry.getClassName();
        long classPK = entry.getClassPK();
        String toName = PropsValues.ANNOUNCEMENTS_EMAIL_TO_NAME;
        String toAddress = PropsValues.ANNOUNCEMENTS_EMAIL_TO_ADDRESS;
        long teamId = 0L;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("announcementsDeliveryEmailOrSms", entry.getType());
        if (classPK > 0L) {
            if (className.equals(Group.class.getName())) {
                Group group = this.groupPersistence.findByPrimaryKey(classPK);
                toName = group.getDescriptiveName();
                params.put("inherit", Boolean.TRUE);
                params.put("usersGroups", classPK);
            } else if (className.equals(Organization.class.getName())) {
                Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
                toName = organization.getName();
                params.put("usersOrgsTree", ListUtil.fromArray((Object[])new Organization[]{organization}));
            } else if (className.equals(Role.class.getName())) {
                Role role = this.rolePersistence.findByPrimaryKey(classPK);
                toName = role.getName();
                if (role.getType() == 1) {
                    params.put("inherit", Boolean.TRUE);
                    params.put("usersRoles", classPK);
                } else if (role.isTeam()) {
                    teamId = role.getClassPK();
                } else {
                    params.put("userGroupRole", new Long[]{0L, classPK});
                }
            } else if (className.equals(UserGroup.class.getName())) {
                UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(classPK);
                toName = userGroup.getName();
                params.put("usersUserGroups", classPK);
            }
        }
        if (className.equals(User.class.getName())) {
            User user = this.userPersistence.findByPrimaryKey(classPK);
            if (Validator.isNull((String)user.getEmailAddress())) {
                return;
            }
            this.notifyUsers(ListUtil.fromArray((Object[])new User[]{user}), entry, company.getLocale(), user.getEmailAddress(), user.getFullName());
        } else {
            this.notifyUsers(entry, teamId, params, toName, toAddress, company);
        }
    }

    protected void notifyUsers(final AnnouncementsEntry entry, final long teamId, final LinkedHashMap<String, Object> params, final String toName, final String toAddress, final Company company) throws PortalException {
        int total = 0;
        total = teamId > 0L ? this.userLocalService.getTeamUsersCount(teamId) : this.userLocalService.searchCount(company.getCompanyId(), null, 0, params);
        final IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((IntervalActionProcessor.PerformIntervalActionMethod)new IntervalActionProcessor.PerformIntervalActionMethod<Void>(){

            public Void performIntervalAction(int start, int end) throws PortalException {
                List users = null;
                users = teamId > 0L ? AnnouncementsEntryLocalServiceImpl.this.userLocalService.getTeamUsers(teamId, start, end) : AnnouncementsEntryLocalServiceImpl.this.userLocalService.search(company.getCompanyId(), null, 0, params, start, end, (OrderByComparator)null);
                AnnouncementsEntryLocalServiceImpl.this.notifyUsers(users, entry, company.getLocale(), toAddress, toName);
                intervalActionProcessor.incrementStart(users.size());
                return null;
            }
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void notifyUsers(List<User> users, AnnouncementsEntry entry, Locale locale, String toAddress, String toName) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Notifying " + users.size() + " users"));
        }
        boolean notifyUsers = false;
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        for (User user : users) {
            AnnouncementsDelivery announcementsDelivery = this.announcementsDeliveryLocalService.getUserDelivery(user.getUserId(), entry.getType());
            if (announcementsDelivery.isEmail()) {
                subscriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
                notifyUsers = true;
            }
            if (!announcementsDelivery.isSms()) continue;
            String smsSn = user.getContact().getSmsSn();
            subscriptionSender.addRuntimeSubscribers(smsSn, user.getFullName());
            notifyUsers = true;
        }
        if (!notifyUsers) {
            return;
        }
        String body = ContentUtil.get((String)PropsValues.ANNOUNCEMENTS_EMAIL_BODY);
        String fromAddress = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.address", "admin.email.from.address");
        String fromName = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.name", "admin.email.from.name");
        String subject = ContentUtil.get((String)PropsValues.ANNOUNCEMENTS_EMAIL_SUBJECT);
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttribute("[$ENTRY_CONTENT$]", (Object)entry.getContent(), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$ENTRY_ID$]", entry.getEntryId(), "[$ENTRY_TITLE$]", entry.getTitle(), "[$ENTRY_TYPE$]", LanguageUtil.get((Locale)locale, (String)entry.getType()), "[$ENTRY_URL$]", entry.getUrl(), "[$PORTLET_NAME$]", LanguageUtil.get((Locale)locale, (String)(entry.isAlert() ? "alert" : "announcement"))});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("announcements_entry", new Object[]{entry.getEntryId()});
        String portletId = PortletProviderUtil.getPortletId((String)AnnouncementsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setSubject(subject);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void validate(String title, String content, String url, Date expirationDate) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
        if (Validator.isNotNull((String)url) && !Validator.isUrl((String)url)) {
            throw new EntryURLException();
        }
        if (expirationDate != null && expirationDate.before(new Date())) {
            throw new EntryExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
    }
}

