/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import com.liferay.portal.upgrade.v7_0_0.util.AssetEntryTable;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;

public class UpgradeAsset
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeAsset.class);

    protected void doUpgrade() throws Exception {
        this.alter(AssetEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "description", "TEXT null"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "summary", "TEXT null")});
        this.updateAssetEntries();
        this.updateAssetVocabularies();
    }

    /*
     * Exception decompiling
     */
    protected long getDDMStructureId(String structureKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle");
            try (PreparedStatement ps1 = this.connection.prepareStatement("select resourcePrimKey, structureId from JournalArticle where structureId != ''");
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch(this.connection.prepareStatement("update AssetEntry set classTypeId = ? where classNameId = ? and classPK = ?"));){
                while (rs.next()) {
                    long resourcePrimKey = rs.getLong("resourcePrimKey");
                    String structureId = rs.getString("structureId");
                    long ddmStructureId = this.getDDMStructureId(structureId);
                    ps2.setLong(1, ddmStructureId);
                    ps2.setLong(2, classNameId);
                    ps2.setLong(3, resourcePrimKey);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
            StringBundler sb = new StringBundler(9);
            sb.append("select JournalArticle.resourcePrimKey from (select ");
            sb.append("JournalArticle.resourcePrimkey as primKey, ");
            sb.append("max(JournalArticle.version) as maxVersion from ");
            sb.append("JournalArticle group by ");
            sb.append("JournalArticle.resourcePrimkey) temp_table inner join ");
            sb.append("JournalArticle on (JournalArticle.indexable = ");
            sb.append("?) and (JournalArticle.status = 0) and ");
            sb.append("(JournalArticle.resourcePrimkey = temp_table.primKey) ");
            sb.append("and (JournalArticle.version = temp_table.maxVersion)");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());){
                ps1.setBoolean(1, false);
                try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch(this.connection.prepareStatement("update AssetEntry set listable = ? where classNameId = ? and classPK = ?"));
                     ResultSet rs = ps1.executeQuery();){
                    while (rs.next()) {
                        long classPK = rs.getLong("resourcePrimKey");
                        ps2.setBoolean(1, false);
                        ps2.setLong(2, classNameId);
                        ps2.setLong(3, classPK);
                        ps2.addBatch();
                    }
                    ps2.executeBatch();
                }
            }
        }
    }

    protected void updateAssetVocabularies() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select vocabularyId, settings_ from AssetVocabulary");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long vocabularyId = rs.getLong("vocabularyId");
                String settings = rs.getString("settings_");
                this.updateAssetVocabulary(vocabularyId, this.upgradeVocabularySettings(settings));
            }
        }
    }

    protected void updateAssetVocabulary(long vocabularyId, String settings) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update AssetVocabulary set settings_ = ? where vocabularyId = ?");){
                ps.setString(1, settings);
                ps.setLong(2, vocabularyId);
                ps.executeUpdate();
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)("Unable to update vocabulary " + vocabularyId), (Throwable)e);
            }
        }
    }

    protected String upgradeVocabularySettings(String settings) {
        UnicodeProperties properties = new UnicodeProperties(true);
        properties.fastLoad(settings);
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setMultiValued(GetterUtil.getBoolean((String)properties.getProperty("multiValued"), (boolean)true));
        long[] classNameIds = StringUtil.split((String)properties.getProperty("selectedClassNameIds"), (long)0L);
        long[] classTypePKs = new long[classNameIds.length];
        Arrays.fill(classTypePKs, -1L);
        long[] requiredClassNameIds = StringUtil.split((String)properties.getProperty("requiredClassNameIds"), (long)0L);
        boolean[] requireds = new boolean[classNameIds.length];
        for (int i = 0; i < classNameIds.length; ++i) {
            requireds[i] = ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameIds[i]);
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        return vocabularySettingsHelper.toString();
    }
}

