/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeMessageBoards
extends UpgradeProcess {
    protected void addThreadFlag(long threadFlagId, long userId, long threadId, Timestamp modifiedDate) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into MBThreadFlag (threadFlagId, userId, modifiedDate, threadId) values (?, ?, ?, ?)");){
            ps.setLong(1, threadFlagId);
            ps.setLong(2, userId);
            ps.setTimestamp(3, modifiedDate);
            ps.setLong(4, threadId);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateMessage();
        this.updateThread();
        this.updateThreadFlag();
    }

    protected void updateMessage() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            try (PreparedStatement ps = this.connection.prepareStatement("select messageId, body from MBMessage where (body like '%<3%') or (body like '%>_>%') or (body like '%<_<%')");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long messageId = rs.getLong("messageId");
                    String body = rs.getString("body");
                    body = StringUtil.replace((String)body, (String[])new String[]{"<3", ">_>", "<_<"}, (String[])new String[]{":love:", ":glare:", ":dry:"});
                    this.updateMessageBody(messageId, body);
                }
            }
            StringBundler sb = new StringBundler(4);
            sb.append("select messageFlag.messageId as messageId from ");
            sb.append("MBMessageFlag messageFlag inner join MBMessage ");
            sb.append("message on messageFlag.messageId = message.messageId ");
            sb.append("where message.parentMessageId != 0 and flag = 3");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long messageId = rs.getLong("messageId");
                    this.updateMessageAnswer(messageId, true);
                }
            }
        }
    }

    protected void updateMessageAnswer(long messageId, boolean answer) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update MBMessage set answer = ? where messageId = " + messageId);){
            ps.setBoolean(1, answer);
            ps.executeUpdate();
        }
    }

    protected void updateMessageBody(long messageId, String body) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update MBMessage set body = ? where messageId = " + messageId);){
            ps.setString(1, body);
            ps.executeUpdate();
        }
    }

    protected void updateThread() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            Throwable throwable;
            ResultSet rs;
            try (PreparedStatement ps = this.connection.prepareStatement("select MBThread.threadId, MBMessage.companyId, MBMessage.userId from MBThread inner join MBMessage on MBThread.rootMessageId = MBMessage.messageId");){
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        long threadId = rs.getLong("threadId");
                        long companyId = rs.getLong("companyId");
                        long userId = rs.getLong("userId");
                        this.runSQL("update MBThread set companyId = " + companyId + ", rootMessageUserId = " + userId + " where threadId = " + threadId);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            ps = this.connection.prepareStatement("select threadId from MBMessageFlag where flag = 2");
            var4_6 = null;
            try {
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        long threadId = rs.getLong("threadId");
                        this.updateThreadQuestion(threadId, true);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                var4_6 = throwable3;
                throw throwable3;
            }
            finally {
                if (ps != null) {
                    if (var4_6 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            StringBundler sb = new StringBundler(4);
            sb.append("select messageFlag.threadId as threadId from ");
            sb.append("MBMessageFlag messageFlag inner join MBMessage ");
            sb.append("message on messageFlag.messageId = message.messageId ");
            sb.append("where message.parentMessageId = 0 and flag = 3");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs2 = ps.executeQuery();){
                while (rs2.next()) {
                    long threadId = rs2.getLong("threadId");
                    this.updateThreadQuestion(threadId, true);
                }
            }
        }
    }

    protected void updateThreadFlag() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select userId, threadId, modifiedDate from MBMessageFlag where flag = 1");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long userId = rs.getLong("userId");
                long threadId = rs.getLong("threadId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                this.addThreadFlag(this.increment(), userId, threadId, modifiedDate);
            }
            this.runSQL("drop table MBMessageFlag");
        }
    }

    protected void updateThreadQuestion(long threadId, boolean question) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update MBThread set question = ? where threadId = " + threadId);){
            ps.setBoolean(1, question);
            ps.executeUpdate();
        }
    }
}

